/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.eternal_starlight_vo.config;

import com.Minor2CCh.eternal_starlight_vo.config.StarlightConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class StarlightConfigLoader {
    public static File DIR = FabricLoader.getInstance().getConfigDir().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILENAME = "eternal_starlight_vo.json";
    private static final Path CONFIG_PATH = Path.of(new File(DIR, "eternal_starlight_vo.json").getPath(), new String[0]);
    private static StarlightConfig modConfig;

    public static void load() {
        System.out.println(CONFIG_PATH);
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                modConfig = (StarlightConfig)GSON.fromJson((Reader)reader, StarlightConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                modConfig = new StarlightConfig();
            }
            modConfig.fillDefaults();
        } else {
            modConfig = new StarlightConfig();
        }
        StarlightConfigLoader.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)modConfig, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public static StarlightConfig getConfig() {
        return modConfig;
    }
}

