/*
 * Decompiled with CFR 0.152.
 */
package net.cookedseafood.messycraft;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.cookedseafood.genericregistry.registry.Registries;
import net.cookedseafood.messycraft.command.CraftCommand;
import net.cookedseafood.messycraft.command.MessyCraftCommand;
import net.cookedseafood.messycraft.recipe.MessyRecipe;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessyCraft
implements ModInitializer {
    public static final String MOD_ID = "messy-craft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"messy-craft");
    public static final byte VERSION_MAJOR = 0;
    public static final byte VERSION_MINOR = 3;
    public static final byte VERSION_PATCH = 0;
    public static final String MOD_NAMESPACE = "messy_craft";
    public static final class_2960 RECIPE_LOADER_ID = class_2960.method_60655((String)"messy_craft", (String)"recipe_loader");
    public static final Pattern PATH_PATTERN = Pattern.compile("^(.+\\/)*(.+)\\.(.+)$");

    public void onInitialize() {
        LOGGER.info("[Messy-Craft] Loaded!");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(RECIPE_LOADER_ID, wrapperLookup -> new SimpleSynchronousResourceReloadListener(){
            private final class_2960 id = RECIPE_LOADER_ID;
            final /* synthetic */ class_7225.class_7874 val$wrapperLookup;
            {
                this.val$wrapperLookup = class_78742;
            }

            public class_2960 getFabricId() {
                return this.id;
            }

            public void method_14491(class_3300 resourceManager) {
                MessyCraft.reloadMessyRecipe(resourceManager, this.val$wrapperLookup);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MessyCraftCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> CraftCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess));
    }

    public static void reloadMessyRecipe(class_3300 resourceManager, class_7225.class_7874 wrapperLookup) {
        LOGGER.info("[Messy-Craft] Reloading recipes!");
        Registries.remove(MessyRecipe.class);
        resourceManager.method_14488("messy_recipe", path -> path.method_12832().endsWith(".json")).entrySet().forEach(resourceEntry -> {
            JsonObject recipeJsonObject;
            class_2960 resourceId = (class_2960)resourceEntry.getKey();
            class_3298 resource = (class_3298)resourceEntry.getValue();
            try {
                recipeJsonObject = (JsonObject)new Gson().fromJson((Reader)resource.method_43039(), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                LOGGER.error("[Messy-Craft] Failed to load recipe " + resourceId.toString() + ".");
                e.printStackTrace();
                return;
            }
            class_2487 recipeNbtCompound = (class_2487)JsonOps.INSTANCE.convertMap((DynamicOps)class_2509.field_11560, (Object)recipeJsonObject);
            MessyRecipe recipe = MessyRecipe.fromNbt(recipeNbtCompound, wrapperLookup);
            String resourceNamespace = resourceId.method_12836();
            String resourcePath = resourceId.method_12832();
            Matcher resourcePathMatcher = PATH_PATTERN.matcher(resourcePath);
            resourcePathMatcher.matches();
            String recipeName = resourcePathMatcher.group(2);
            class_2960 recipeId = class_2960.method_60655((String)resourceNamespace, (String)recipeName);
            Registries.register((class_2960)recipeId, (Object)recipe);
        });
    }
}

