package net.cookedseafood.messycraft;

import java.util.regex.Pattern;
import net.cookedseafood.messycraft.command.CraftCommand;
import net.cookedseafood.messycraft.command.MessyCraftCommand;
import net.cookedseafood.messycraft.recipe.MessyRecipe;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessyCraft implements ModInitializer {
    public static final String MOD_ID = "messy-craft";

    // This logger is used to write text to the console and the log file.
    // It is considered best practice to use your mod id as the logger's name.
    // That way, it's clear which mod wrote info, warnings, and errors.
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static final String MOD_NAMESPACE = "messy_craft";

    public static final byte VERSION_MAJOR = 0;
    public static final byte VERSION_MINOR = 4;
    public static final byte VERSION_PATCH = 1;

    public static final class_2960 RECIPE_LOADER_ID = class_2960.method_60655(MOD_NAMESPACE, "recipe_loader");
    public static final Pattern PATH_PATTERN = Pattern.compile("^(.+\\/)*(.+)\\.(.+)$");

    @Override
    public void onInitialize() {
        // This code runs as soon as Minecraft is in a mod-load-ready state.
        // However, some things (like resources) may still be uninitialized.
        // Proceed with mild caution.

        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(RECIPE_LOADER_ID, wrapperLookup -> {
            return new SimpleSynchronousResourceReloadListener() {
                private final class_2960 id = RECIPE_LOADER_ID;

                @Override
                public class_2960 getFabricId() {
                    return id;
                }

                @Override
                public void method_14491(class_3300 resourceManager) {
                    MessyRecipe.reload(resourceManager, wrapperLookup);
                }
            };
        });

        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MessyCraftCommand.register(dispatcher, registryAccess));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> CraftCommand.register(dispatcher, registryAccess));
    }
}
