package net.cookedseafood.messycraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.cookedseafood.messycraft.recipe.MessyRecipe;
import net.cookedseafood.messycraft.suggestion.MessyRecipeSuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class CraftCommand {
    private static final SimpleCommandExceptionType INGREDIENT_INSUFFICIENT_EXCEPTION =
        new SimpleCommandExceptionType(class_2561.method_43470("Missing materials."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        LiteralCommandNode<class_2168> craft = dispatcher.register(
            class_2170.method_9247("craft")
            .then(
                class_2170.method_9244("item", StringArgumentType.string())
                .suggests(new MessyRecipeSuggestionProvider())
                .executes(context -> craft(context.getSource(), StringArgumentType.getString(context, "item")))
                .then(
                    class_2170.method_9244("count", IntegerArgumentType.integer(1))
                    .executes(context -> craft(context.getSource(), StringArgumentType.getString(context, "item"), IntegerArgumentType.getInteger(context, "count")))
                )
            )
        );
        dispatcher.register(class_2170.method_9247("c").redirect(craft));
    }

    public static int craft(class_2168 source, String item) throws CommandSyntaxException {
        return craft(source, item, 1);
    }

    public static int craft(class_2168 source, String item, int count) throws CommandSyntaxException {
        boolean isSuccessful = MessyRecipe.craft(class_2960.method_60654(item.replace('.', ':')), count, source.method_9207());

        if (isSuccessful) {
            return 1;
        } else {
            throw INGREDIENT_INSUFFICIENT_EXCEPTION.create();
        }
    }
}
