package net.cookedseafood.messycraft.recipe;

import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class MessyItemStack {
    private class_1799 itemStack;

    public MessyItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    public static MessyItemStack of(class_1799 itemStack) {
        return new MessyItemStack(itemStack);
    }

    public static MessyItemStack of(class_1935 item) {
        return MessyItemStack.of(new class_1799(item));
    }

    public boolean isIn(class_1661 inventory) {
        int count = this.getCount();

        int presentedCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (class_1799.method_31577(itemStack, this.itemStack)) {
                presentedCount += itemStack.method_7947();
                if (presentedCount >= count) {
                    return true;
                }
            }
        }

        return false;
    }

    public int removeFrom(class_1661 inventory) {
        return inventory.method_29280(itemStack -> class_1799.method_31577(itemStack, this.itemStack), this.getCount(), inventory.field_7546.field_7498.method_29281());
    }

    public boolean insertTo(class_1661 inventory) {
        return inventory.method_7394(this.itemStack);
    }

    public boolean removeFrom(MessyIngredient ingredients) {
        return ingredients.remove(this);
    }

    public void times(int times) {
        this.setCount(this.getCount() * times);
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    public class_2960 getId() {
        return this.itemStack.getId();
    }

    public String getIdAsString() {
        return this.itemStack.getIdAsString();
    }

    public String getCustomIdOrId() {
        return this.itemStack.getCustomIdOrId();
    }

    public String getCustomId() {
        return this.itemStack.getCustomId();
    }

    public int getCount() {
        return this.itemStack.method_7947();
    }

    public void setCount(int count) {
        this.itemStack.method_7939(count);
    }

    public class_9323 getComponents() {
        return this.itemStack.method_57353();
    }

    public class_9326 getComponentChanges() {
        return this.itemStack.method_57380();
    }

    public <T> T set(class_9331<T> type, @Nullable T value) {
        return this.itemStack.method_57379(type, value);
    }

    @Override
    public String toString() {
        return this.itemStack.toString();
    }

    public MessyItemStack copy() {
        return new MessyItemStack(this.itemStack);
    }

    public MessyItemStack deepCopy() {
        return new MessyItemStack(this.itemStack.method_7972());
    }

    public static MessyItemStack fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new MessyItemStack(class_1799.field_24671.parse(class_2509.field_11560, nbtCompound).getOrThrow());
    }

    public class_2520 toNbt(class_7225.class_7874 wrapperLookup) {
        return class_1799.field_24671.encode(this.itemStack, class_2509.field_11560, new class_2487()).getOrThrow();
    }
}
