package net.cookedseafood.messycraft.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.cookedseafood.genericregistry.registry.Registries;
import net.cookedseafood.messycraft.recipe.MessyRecipe;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2960;

public class MessyRecipeSuggestionProvider implements SuggestionProvider<class_2168> {
    @Override
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Registries.get(MessyRecipe.class).entrySet()
            .forEach(recipeEntry -> {
                class_2960 id = recipeEntry.getKey();
                MessyRecipe recipe = recipeEntry.getValue();

                String candidate = id.toString().replace(':', '.');
                if (class_2172.method_27136(builder.getRemaining(), candidate)) {
                    builder.suggest(candidate, recipe.getIngredients()::toString);
                }
            });

        return builder.buildFuture();
    }
}
