/*
 * Decompiled with CFR 0.152.
 */
package net.cookedseafood.messycraft.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import net.cookedseafood.genericregistry.registry.Registries;
import net.cookedseafood.messycraft.MessyCraft;
import net.cookedseafood.messycraft.api.CraftMessyRecipeCallback;
import net.cookedseafood.messycraft.recipe.MessyIngredient;
import net.cookedseafood.messycraft.recipe.MessyItemStack;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_7225;
import org.apache.commons.lang3.mutable.MutableInt;

public class MessyRecipe {
    private MessyIngredient ingredients;
    private MessyItemStack result;

    public MessyRecipe(MessyIngredient ingredients, MessyItemStack result) {
        this.ingredients = ingredients;
        this.result = result;
    }

    public static boolean craft(class_2960 recipeId, int times, class_3222 player) {
        MessyRecipe recipe = (MessyRecipe)Registries.get(MessyRecipe.class, (class_2960)recipeId);
        if (recipe == null) {
            return false;
        }
        return recipe.deepCopy().craft(times, player);
    }

    public boolean craft(int times, class_3222 player) {
        class_1661 inventory = player.method_31548();
        MessyIngredient ingredients = this.getIngredients();
        ingredients.times(times);
        if (!ingredients.isIn(inventory)) {
            return false;
        }
        ((CraftMessyRecipeCallback)CraftMessyRecipeCallback.EVENT.invoker()).interact((class_1657)player, this, times);
        ingredients.removeFrom(inventory);
        MessyItemStack result = this.getResult();
        result.times(times);
        result.insertTo(inventory);
        return true;
    }

    public MessyIngredient getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(MessyIngredient ingredients) {
        this.ingredients = ingredients;
    }

    public MessyItemStack getResult() {
        return this.result;
    }

    public void setResult(MessyItemStack result) {
        this.result = result;
    }

    public MessyRecipe copy() {
        return new MessyRecipe(this.ingredients, this.result);
    }

    public MessyRecipe deepCopy() {
        return new MessyRecipe(this.ingredients.deepCopy(), this.result.deepCopy());
    }

    public static MessyRecipe fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new MessyRecipe(MessyIngredient.fromNbt(nbtCompound.method_68569("ingredients"), wrapperLookup), MessyItemStack.fromNbt(nbtCompound.method_68568("result"), wrapperLookup));
    }

    public class_2487 toNbt(class_7225.class_7874 wrapperLookup) {
        return new class_2487(new HashMap<String, class_2520>(Map.of("ingredients", this.ingredients.toNbt(wrapperLookup), "result", this.result.toNbt(wrapperLookup))));
    }

    public static void reload(class_3300 resourceManager, class_7225.class_7874 wrapperLookup) {
        Registries.remove(MessyRecipe.class);
        MessyRecipe.load(resourceManager, wrapperLookup);
    }

    public static void load(class_3300 resourceManager, class_7225.class_7874 wrapperLookup) {
        MutableInt loadedCount = new MutableInt(0);
        resourceManager.method_14488("messy_recipe", path -> path.method_12832().endsWith(".json")).forEach((resourceId, resource) -> {
            JsonObject recipeJsonObject;
            try {
                BufferedReader reader = resource.method_43039();
                recipeJsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                reader.close();
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                MessyCraft.LOGGER.error("[Messy-Craft] Failed to load recipe from " + resourceId.toString(), e);
                return;
            }
            if (recipeJsonObject == null) {
                MessyCraft.LOGGER.error("[Messy-Craft] Failed to load recipe from " + resourceId.toString() + ": Json is at EOF.");
                return;
            }
            Matcher matcher = MessyCraft.PATH_PATTERN.matcher(resourceId.method_12832());
            if (!matcher.matches()) {
                MessyCraft.LOGGER.error("[Messy-Craft] Failed to load recipe from " + resourceId.toString() + ": Invalid path.");
                return;
            }
            class_2960 recipeId = class_2960.method_60655((String)resourceId.method_12836(), (String)matcher.group(2));
            class_2487 recipeNbtCompound = (class_2487)JsonOps.INSTANCE.convertMap((DynamicOps)class_2509.field_11560, (Object)recipeJsonObject);
            MessyRecipe recipe = MessyRecipe.fromNbt(recipeNbtCompound, wrapperLookup);
            Registries.register((class_2960)recipeId, (Object)recipe);
            loadedCount.increment();
        });
        MessyCraft.LOGGER.info("[Messy-Craft] Loaded " + loadedCount.intValue() + " recipes.");
    }
}

