/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.exceptions.InvalidFishException;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.selling.WorthNBT;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class SkullSaver
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPlayer().getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        Block block = event.getBlock();
        if (!this.isHead(block)) {
            return;
        }
        if (block.getDrops().isEmpty()) {
            return;
        }
        BlockState state = event.getBlock().getState();
        Skull skullMeta = (Skull)state;
        if (!FishUtils.isFish(skullMeta)) {
            return;
        }
        ItemStack stack = ((ItemStack)block.getDrops().iterator().next()).clone();
        event.setCancelled(true);
        event.setDropItems(false);
        try {
            Fish f = FishUtils.getFish(skullMeta, event.getPlayer());
            if (f == null) {
                return;
            }
            ItemStack fishItem = f.give();
            if (fishItem == null) {
                return;
            }
            stack.setItemMeta(fishItem.getItemMeta());
            block.setType(Material.AIR);
            block.getWorld().dropItemNaturally(block.getLocation(), stack);
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_BONE_BLOCK_BREAK, 1.0f, 1.0f);
        }
        catch (InvalidFishException exception) {
            EvenMoreFish.getInstance().getLogger().severe(() -> String.format("Error fetching fish from config at location: x:%d y:%d z:%d world:%s", block.getLocation().getBlockX(), block.getLocation().getBlockY(), block.getLocation().getBlockZ(), block.getLocation().getBlock().getWorld().getName()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        ItemStack stack = event.getItemInHand();
        if (stack.getAmount() == 0 || !stack.hasItemMeta()) {
            return;
        }
        if (FishUtils.isFish(stack)) {
            BlockState blockState = block.getState();
            if (blockState instanceof Skull) {
                Skull sm = (Skull)blockState;
                Fish fish = FishUtils.getFish(stack);
                if (fish != null) {
                    WorthNBT.setNBT(sm, fish);
                    sm.update();
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    private boolean isHead(Block block) {
        return block.getType() == Material.PLAYER_HEAD || block.getType() == Material.PLAYER_WALL_HEAD;
    }
}

