/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import java.time.Instant;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class IRLTimeRequirementType
extends RequirementType {
    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        long currentTime = Instant.now().getEpochSecond() / 60L % 1440L + 60L;
        for (String value : values) {
            int maxTime;
            int minTime;
            String[] split = value.split("-");
            try {
                minTime = this.getDayMinute(split[0], 0);
                maxTime = this.getDayMinute(split[1], 1440);
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                EvenMoreFish.getInstance().getLogger().severe(value + " is not a valid real time format. Using the defaults.");
                minTime = 0;
                maxTime = 1440;
            }
            if (currentTime < (long)minTime || currentTime >= (long)maxTime) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "IRL-TIME";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }

    private int getDayMinute(@NotNull String HHMMFormat, int fallback) {
        String[] time = HHMMFormat.split(":");
        try {
            return Integer.parseInt(time[0]) * 60 + Integer.parseInt(time[1]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException exception) {
            EvenMoreFish.getInstance().getLogger().severe("FATAL error reading " + HHMMFormat + ", resorting to default value of " + fallback);
            return fallback;
        }
    }
}

