/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import com.oheers.fish.config.MainConfig;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NearbyPlayersRequirementType
extends RequirementType {
    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        Player player = context.getPlayer();
        if (player == null) {
            String configLocation = context.getConfigPath();
            if (configLocation == null) {
                configLocation = "N/A";
            }
            EvenMoreFish.getInstance().getLogger().warning("Could not find a valid player for " + configLocation + ", returning false by default. The player may not have been given a fish if you see this message multiple times.");
            return false;
        }
        int range = MainConfig.getInstance().getNearbyPlayersRequirementRange();
        long nearbyPlayers = context.getPlayer().getNearbyEntities((double)range, (double)range, (double)range).stream().filter(entity -> entity instanceof Player).count();
        for (String value : values) {
            int nearbyRequirement;
            try {
                nearbyRequirement = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                EvenMoreFish.getInstance().getLogger().severe(value + " is not a valid integer");
                return false;
            }
            if (nearbyPlayers < (long)nearbyRequirement) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "NEARBY-PLAYERS";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "FireML";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

