/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.reward;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.reward.RewardType;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SoundRewardType
extends RewardType {
    @Override
    public void doReward(@NotNull Player player, @NotNull String key, @NotNull String value, Location hookLocation) {
        float pitch;
        float volume;
        Sound sound;
        String[] split = value.split(",");
        try {
            sound = Sound.valueOf((String)split[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            EvenMoreFish.getInstance().getLogger().warning("Invalid sound specified for RewardType " + this.getIdentifier() + ": " + value);
            return;
        }
        try {
            volume = Float.parseFloat(split[1]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            volume = 1.0f;
        }
        try {
            pitch = Float.parseFloat(split[2]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            pitch = 1.0f;
        }
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "SOUND";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "FireML";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

