/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api;

import com.oheers.fish.api.FileUtil;
import com.oheers.fish.api.Logging;
import com.oheers.fish.api.plugin.EMFPlugin;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFileBasedManager<T> {
    protected AbstractFileBasedManager<?> dependency;
    protected final TreeMap<String, T> itemMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private boolean loaded = false;

    protected AbstractFileBasedManager() {
        this.dependency = null;
        this.performPreLoadConversions();
    }

    protected AbstractFileBasedManager(AbstractFileBasedManager<?> dependency) {
        this.dependency = dependency;
        this.performPreLoadConversions();
    }

    public void load() {
        if (this.isLoaded()) {
            return;
        }
        if (this.dependency != null && !this.dependency.isLoaded()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " cannot load before " + this.dependency.getClass().getSimpleName());
        }
        this.loadItems();
        this.logLoadedItems();
        this.loaded = true;
    }

    public void reload() {
        if (!this.isLoaded()) {
            return;
        }
        this.clearMap(true);
        this.loadItems();
        this.logLoadedItems();
    }

    public void unload() {
        if (!this.isLoaded()) {
            return;
        }
        this.clearMap(false);
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @NotNull
    public TreeMap<String, T> getItemMap() {
        return this.itemMap;
    }

    @Nullable
    public T getItem(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        return this.itemMap.get(id);
    }

    protected abstract void loadItems();

    protected abstract void logLoadedItems();

    protected abstract void performPreLoadConversions();

    protected void clearMap(boolean reload) {
        this.itemMap.clear();
    }

    protected <U> void loadItemsFromFiles(String folderName, FunctionWithException<File, U, InvalidConfigurationException> itemLoader, Function<U, String> idExtractor, Predicate<U> shouldSkipItem) {
        File itemsFolder = new File(EMFPlugin.getInstance().getDataFolder(), folderName);
        if (!itemsFolder.exists()) {
            FileUtil.loadDefaultFiles(folderName, itemsFolder);
        }
        FileUtil.regenExampleFiles(folderName, itemsFolder);
        List<File> itemFiles = FileUtil.getFilesInDirectory(itemsFolder, true, true);
        if (itemFiles.isEmpty()) {
            EMFPlugin.getInstance().debug("No files found in directory: " + String.valueOf(itemsFolder));
            return;
        }
        itemFiles.stream().map(file -> {
            try {
                return itemLoader.apply((File)file);
            }
            catch (InvalidConfigurationException e) {
                Logging.warn("Invalid configuration in file: " + file.getName());
                Logging.warn(e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).filter(item -> !shouldSkipItem.test(item)).forEach(item -> {
            String id = (String)idExtractor.apply(item);
            if (this.itemMap.containsKey(id)) {
                Logging.warn("An item with the ID '" + id + "' already exists! Skipping.");
                return;
            }
            this.itemMap.put(id, item);
        });
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

