/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.addons;

import com.oheers.fish.libs.universalScheduler.UniversalRunnable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class Futures {
    private Futures() {
    }

    public static <T> void onMainThread(@NotNull Plugin plugin, @NotNull CompletableFuture<T> future, final @NotNull BiConsumer<T, Throwable> consumer) {
        future.whenComplete((value, exception) -> {
            if (Bukkit.isPrimaryThread()) {
                consumer.accept((Object)value, (Throwable)exception);
            } else {
                new UniversalRunnable((Throwable)exception){
                    final /* synthetic */ Throwable val$exception;
                    {
                        this.val$exception = throwable;
                    }

                    @Override
                    public void run() {
                        consumer.accept(value, this.val$exception);
                    }
                }.runTask(plugin);
            }
        });
    }

    @NotNull
    public static <T> Collector<CompletableFuture<T>, ?, CompletableFuture<List<T>>> collector() {
        return Collectors.collectingAndThen(Collectors.toList(), Futures::of);
    }

    @NotNull
    public static <T> CompletableFuture<List<T>> of(@NotNull Stream<CompletableFuture<T>> futures) {
        return Futures.of(futures.collect(Collectors.toList()));
    }

    @NotNull
    public static <T> CompletableFuture<List<T>> of(@NotNull Collection<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApplyAsync($ -> Futures.awaitCompletion(futures));
    }

    @NotNull
    private static <T> List<T> awaitCompletion(@NotNull Collection<CompletableFuture<T>> futures) {
        return futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
    }
}

