/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.baits.manager;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.baits.model.ApplicationResult;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.exceptions.MaxBaitReachedException;
import com.oheers.fish.exceptions.MaxBaitsReachedException;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.utils.WeightedRandom;
import com.oheers.fish.utils.nbt.NbtKeys;
import com.oheers.fish.utils.nbt.NbtUtils;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.iface.ReadWriteNBT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaitNBTManager {
    public static final int UNLIMITED_BAIT = -1;
    public static final String BAIT_SEPARATOR = ":";
    public static final String BAIT_ENTRY_DELIMITER = ",";
    public static final String LINE_IDENTIFIER = "\u200c";

    private BaitNBTManager() {
        throw new UnsupportedOperationException();
    }

    public static boolean isBaitObject(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.hasItemMeta()) {
            return NbtUtils.hasKey(itemStack, "emf-bait");
        }
        return false;
    }

    @Nullable
    public static String getBaitName(@NotNull ItemStack itemStack) {
        if (itemStack.hasItemMeta()) {
            return NbtUtils.getString(itemStack, "emf-bait");
        }
        return null;
    }

    public static ItemStack applyBaitNBT(ItemStack item, String bait) {
        if (item == null) {
            return null;
        }
        NBT.modify(item, nbt -> nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND).setString("emf-bait", bait));
        return item;
    }

    public static boolean isBaitedRod(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.getType() != Material.FISHING_ROD) {
            return false;
        }
        if (itemStack.hasItemMeta()) {
            return NbtUtils.hasKey(itemStack, "emf-applied-bait");
        }
        return false;
    }

    public static ApplicationResult applyBaitedRodNBT(ItemStack item, BaitHandler bait, int quantity) throws MaxBaitsReachedException, MaxBaitReachedException {
        boolean doingLoreStuff = MainConfig.getInstance().getBaitAddToLore();
        AtomicBoolean maxBait = new AtomicBoolean(false);
        AtomicInteger cursorModifier = new AtomicInteger();
        StringBuilder combined = new StringBuilder();
        if (BaitNBTManager.isBaitedRod(item)) {
            BaitNBTManager.removeOldLoreIfNecessary(item, bait);
            boolean foundBait = BaitNBTManager.applyToExistingBaits(item, bait, quantity, combined, cursorModifier, maxBait);
            if (!foundBait) {
                BaitNBTManager.addNewBait(item, bait, quantity, combined, cursorModifier, maxBait, doingLoreStuff);
            } else if (!combined.isEmpty()) {
                combined.deleteCharAt(combined.length() - 1);
            }
            BaitNBTManager.updateNBT(item, combined);
        } else {
            BaitNBTManager.applyInitialBait(item, bait, quantity, combined, cursorModifier, maxBait);
        }
        if (doingLoreStuff && !combined.isEmpty()) {
            item.editMeta(meta -> meta.lore(BaitNBTManager.newApplyLore(item)));
        }
        if (maxBait.get()) {
            throw new MaxBaitReachedException(bait, new ApplicationResult(item, cursorModifier.get()));
        }
        return new ApplicationResult(item, cursorModifier.get());
    }

    private static void addNewBait(ItemStack item, BaitHandler bait, int quantity, StringBuilder combined, AtomicInteger cursorModifier, AtomicBoolean maxBait, boolean doingLoreStuff) throws MaxBaitsReachedException {
        if (BaitNBTManager.getNumBaitsApplied(item) >= MainConfig.getInstance().getBaitsPerRod()) {
            if (doingLoreStuff) {
                item.editMeta(meta -> meta.lore(BaitNBTManager.newApplyLore(item)));
            }
            throw new MaxBaitsReachedException("Max baits reached.", new ApplicationResult(item, cursorModifier.get()));
        }
        int maxApplications = bait.getBaitData().maxApplications();
        if (quantity > maxApplications && maxApplications != -1) {
            cursorModifier.set(-maxApplications);
            combined.append(bait.getId()).append(BAIT_SEPARATOR).append(maxApplications);
            maxBait.set(true);
        } else {
            combined.append(bait.getId()).append(BAIT_SEPARATOR).append(quantity);
            cursorModifier.set(-quantity);
        }
    }

    private static void removeOldLoreIfNecessary(@NotNull ItemStack item, BaitHandler bait) {
        try {
            item.editMeta(meta -> meta.lore(BaitNBTManager.deleteOldLore(item)));
        }
        catch (IndexOutOfBoundsException ex) {
            EvenMoreFish.getInstance().getLogger().severe("Failed to apply bait: " + bait.getId() + " to a user's fishing rod. Check baits.yml format.");
            throw new RuntimeException("Lore removal failed.", ex);
        }
    }

    private static boolean applyToExistingBaits(ItemStack item, BaitHandler bait, int quantity, StringBuilder combined, AtomicInteger cursorModifier, AtomicBoolean maxBait) {
        boolean foundBait = false;
        for (String baitName : NbtUtils.getBaitArray(item)) {
            int baitQuantity;
            String[] split = baitName.split(BAIT_SEPARATOR);
            String baitId = split[0];
            int n = baitQuantity = "\u221e".equals(split[1]) ? -1 : Integer.parseInt(split[1]);
            if (baitId.equals(bait.getId())) {
                if (bait.getBaitData().infinite() || baitQuantity == -1) {
                    combined.append(baitId).append(":\u221e,");
                } else {
                    int newQuantity = baitQuantity + quantity;
                    int maxApplications = bait.getBaitData().maxApplications();
                    if (newQuantity > maxApplications && maxApplications != -1) {
                        combined.append(baitId).append(BAIT_SEPARATOR).append(maxApplications).append(BAIT_ENTRY_DELIMITER);
                        cursorModifier.set(-maxApplications + (newQuantity - quantity));
                        maxBait.set(true);
                    } else if (newQuantity != 0) {
                        combined.append(baitId).append(BAIT_SEPARATOR).append(newQuantity).append(BAIT_ENTRY_DELIMITER);
                        cursorModifier.set(-quantity);
                    }
                }
                foundBait = true;
                continue;
            }
            combined.append(baitName).append(BAIT_ENTRY_DELIMITER);
        }
        return foundBait;
    }

    private static void updateNBT(ItemStack item, StringBuilder combined) {
        NBT.modify(item, nbt -> {
            ReadWriteNBT compound = nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND);
            if (combined.isEmpty()) {
                compound.removeKey("emf-applied-bait");
            } else {
                compound.setString("emf-applied-bait", combined.toString());
            }
        });
    }

    private static void applyInitialBait(ItemStack item, BaitHandler bait, int quantity, StringBuilder combined, AtomicInteger cursorModifier, AtomicBoolean maxBait) {
        NBT.modify(item, nbt -> {
            ReadWriteNBT compound = nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND);
            int maxApplications = bait.getBaitData().maxApplications();
            if (quantity > maxApplications && maxApplications != -1) {
                combined.append(bait.getId()).append(BAIT_SEPARATOR).append(maxApplications);
                cursorModifier.set(-maxApplications);
                maxBait.set(true);
            } else {
                combined.append(bait.getId()).append(BAIT_SEPARATOR).append(quantity);
                cursorModifier.set(-quantity);
            }
            compound.setString("emf-applied-bait", combined.toString());
        });
    }

    @Nullable
    public static BaitHandler randomBaitApplication(ItemStack fishingRod) {
        if (fishingRod == null || fishingRod.getItemMeta() == null) {
            return null;
        }
        String[] baitNameList = NbtUtils.getBaitArray(fishingRod);
        ArrayList<BaitHandler> baitList = new ArrayList<BaitHandler>();
        for (String baitName : baitNameList) {
            BaitHandler bait2 = BaitManager.getInstance().getBait(baitName.split(BAIT_SEPARATOR)[0]);
            if (bait2 == null) continue;
            baitList.add(bait2);
        }
        if (baitList.isEmpty()) {
            return null;
        }
        return WeightedRandom.pick(baitList, bait -> bait.getBaitData().applicationWeight(), EvenMoreFish.getInstance().getRandom());
    }

    public static Optional<BaitHandler> randomBaitCatch() {
        TreeMap baitMap = BaitManager.getInstance().getItemMap();
        List<BaitHandler> baitList = baitMap.values().stream().filter(bait -> bait.getBaitData().canBeCaught()).toList();
        if (baitList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(WeightedRandom.pick(baitList, bait -> bait.getBaitData().catchWeight(), EvenMoreFish.getInstance().getRandom()));
    }

    public static boolean hasBaitApplied(ItemStack itemStack, String bait) {
        String[] baitList;
        if (itemStack == null) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        for (String appliedBait : baitList = NbtUtils.getBaitArray(itemStack)) {
            if (!appliedBait.split(BAIT_SEPARATOR)[0].equals(bait)) continue;
            return true;
        }
        return false;
    }

    public static int deleteAllBaits(ItemStack itemStack) {
        if (!NbtUtils.hasKey(itemStack, "emf-applied-bait")) {
            return 0;
        }
        String[] baitList = NbtUtils.getBaitArray(itemStack);
        int totalDeleted = Arrays.stream(baitList).filter(Objects::nonNull).mapToInt(bait -> {
            String[] parts = bait.split(BAIT_SEPARATOR);
            return BaitNBTManager.getDeletedFromQuantityString(parts[1]);
        }).sum();
        NBT.modify(itemStack, nbt -> nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND).removeKey("emf-applied-bait"));
        return totalDeleted;
    }

    private static int getDeletedFromQuantityString(String quantityStr) {
        if (!quantityStr.equals("\u221e")) {
            return Integer.parseInt(quantityStr);
        }
        return 1;
    }

    public static List<Component> newApplyLore(ItemStack itemStack) {
        NBT.modify(itemStack, nbt -> {
            ReadWriteNBT compound = nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND);
            compound.setBoolean("emf-bait-reformatted", true);
        });
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> lore = meta.lore();
        if (lore == null) {
            lore = new ArrayList<Component>();
        }
        EMFListMessage format = ConfigMessage.BAIT_ROD_LORE.getMessage().toListMessage();
        Supplier<EMFListMessage> baitVariable = () -> {
            String[] baitRodNbt;
            EMFListMessage message = EMFListMessage.empty();
            String rodNBT = NbtUtils.getString(itemStack, "emf-applied-bait");
            if (rodNBT == null || rodNBT.isEmpty()) {
                return message;
            }
            for (String bait : baitRodNbt = rodNBT.split(BAIT_ENTRY_DELIMITER)) {
                EMFMessage baitFormat = ConfigMessage.BAIT_BAITS.getMessage();
                String[] parts = bait.split(BAIT_SEPARATOR);
                if (parts.length == 2) {
                    baitFormat.setAmount(parts[1]);
                } else {
                    baitFormat.setAmount("N/A");
                }
                baitFormat.setBait(BaitNBTManager.getBaitFormatted(parts[0]));
                message.appendMessage(baitFormat);
            }
            if (MainConfig.getInstance().getBaitShowUnusedSlots()) {
                for (int i = baitRodNbt.length; i < MainConfig.getInstance().getBaitsPerRod(); ++i) {
                    message.appendMessage(ConfigMessage.BAIT_UNUSED_SLOT.getMessage());
                }
            }
            return message;
        };
        format.setVariableWithListInsertion("{baits}", baitVariable.get());
        format.setCurrentBaits(Integer.toString(BaitNBTManager.getNumBaitsApplied(itemStack)));
        format.setMaxBaits(Integer.toString(MainConfig.getInstance().getBaitsPerRod()));
        lore.addAll(format.getComponentListMessage().stream().map(component -> (TextComponent)Component.text((String)LINE_IDENTIFIER).append(component)).toList());
        return lore;
    }

    public static List<Component> deleteOldLore(ItemStack itemStack) {
        if (BaitNBTManager.removeOldLoreFormat(itemStack)) {
            return itemStack.lore();
        }
        List lore = itemStack.lore();
        if (lore == null || lore.isEmpty()) {
            return Collections.emptyList();
        }
        return lore.stream().filter(component -> !PlainTextComponentSerializer.plainText().serialize(component).startsWith(LINE_IDENTIFIER)).toList();
    }

    private static int getNumBaitsApplied(ItemStack itemStack) {
        String rodNBT = NbtUtils.getString(itemStack, "emf-applied-bait");
        if (rodNBT == null) {
            return 1;
        }
        return rodNBT.split(BAIT_ENTRY_DELIMITER).length;
    }

    private static EMFSingleMessage getBaitFormatted(String baitID) {
        BaitHandler bait = BaitManager.getInstance().getBait(baitID);
        if (bait == null) {
            EvenMoreFish.getInstance().getLogger().warning(() -> "Bait %s is not a valid bait!".formatted(baitID));
            return EMFSingleMessage.fromString("Invalid Bait");
        }
        return EMFSingleMessage.fromString(bait.getDisplayName());
    }

    private static boolean removeOldLoreFormat(@NotNull ItemStack item) {
        if (NbtUtils.hasKey(item, "emf-bait-reformatted")) {
            return false;
        }
        if (!item.hasItemMeta() || item.getItemMeta() == null || !item.getItemMeta().hasLore()) {
            return true;
        }
        List lore = item.lore();
        if (lore == null || lore.isEmpty()) {
            return true;
        }
        if (MainConfig.getInstance().getBaitShowUnusedSlots()) {
            int maxBaits = MainConfig.getInstance().getBaitsPerRod() + ConfigMessage.BAIT_ROD_LORE.getMessage().getPlainTextListMessage().size();
            for (int i = 1; i < maxBaits; ++i) {
                try {
                    lore.remove(lore.size() - 1);
                    continue;
                }
                catch (IndexOutOfBoundsException exception) {
                    break;
                }
            }
        } else {
            int numBaitsApplied = BaitNBTManager.getNumBaitsApplied(item) + ConfigMessage.BAIT_ROD_LORE.getMessage().getPlainTextListMessage().size();
            for (int i = 1; i < numBaitsApplied; ++i) {
                try {
                    lore.remove(lore.size() - 1);
                    continue;
                }
                catch (IndexOutOfBoundsException exception) {
                    break;
                }
            }
        }
        item.lore(lore);
        NBT.modify(item, nbt -> {
            ReadWriteNBT compound = nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND);
            compound.setBoolean("emf-bait-reformatted", true);
        });
        return true;
    }
}

