/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands;

import com.oheers.fish.config.MainConfig;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.util.HashMap;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class HelpMessageBuilder {
    private final HashMap<String, Supplier<EMFMessage>> usages;

    private HelpMessageBuilder(@NotNull HashMap<String, Supplier<EMFMessage>> usages) {
        this.usages = usages;
    }

    public static HelpMessageBuilder create() {
        return new HelpMessageBuilder(new HashMap<String, Supplier<EMFMessage>>());
    }

    public static HelpMessageBuilder create(@NotNull HashMap<String, Supplier<EMFMessage>> usages) {
        return new HelpMessageBuilder(usages);
    }

    public HelpMessageBuilder addUsage(@NotNull String name, @NotNull Supplier<EMFMessage> helpMessage) {
        this.usages.putIfAbsent(name, helpMessage);
        return this;
    }

    public EMFMessage buildMessage() {
        EMFListMessage message = ConfigMessage.HELP_GENERAL_TITLE.getMessage().toListMessage();
        this.usages.forEach((key, value) -> {
            EMFMessage description = (EMFMessage)value.get();
            if (description == null || description.isEmpty()) {
                return;
            }
            EMFMessage usage = ConfigMessage.HELP_FORMAT.getMessage();
            usage.setVariable("{command}", this.correctCommand((String)key));
            usage.setVariable("{description}", description);
            message.appendMessage(usage);
        });
        return message;
    }

    private String correctCommand(@NotNull String key) {
        return "/" + MainConfig.getInstance().getMainCommandName() + " " + key;
    }

    public void sendMessage(@NotNull CommandSender sender) {
        this.buildMessage().send((Audience)sender);
    }
}

