/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.EMFCompetitionEndEvent;
import com.oheers.fish.api.EMFCompetitionStartEvent;
import com.oheers.fish.api.Logging;
import com.oheers.fish.api.reward.Reward;
import com.oheers.fish.competition.Bar;
import com.oheers.fish.competition.CompetitionEntry;
import com.oheers.fish.competition.CompetitionStrategy;
import com.oheers.fish.competition.CompetitionTimer;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.configs.CompetitionFile;
import com.oheers.fish.competition.leaderboard.Leaderboard;
import com.oheers.fish.config.MessageConfig;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.model.CompetitionReport;
import com.oheers.fish.database.model.user.UserReport;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Competition {
    private static Competition active;
    private boolean originallyRandom;
    private Leaderboard leaderboard;
    private CompetitionType competitionType;
    private Fish selectedFish;
    private Rarity selectedRarity;
    private String competitionName;
    private boolean adminStarted = false;
    private EMFMessage startMessage;
    private long maxDuration;
    private long timeLeft;
    private Bar statusBar;
    private long epochStartTime;
    private LocalDateTime startTime;
    private final List<Long> alertTimes;
    private final Map<Integer, List<Reward>> rewards;
    private int playersNeeded;
    private Sound startSound;
    private CompetitionTimer timingSystem;
    private CompetitionFile competitionFile;
    private int numberNeeded = 0;
    private Player singleWinner = null;

    public Competition(@NotNull CompetitionFile competitionFile) {
        this.competitionFile = competitionFile;
        this.competitionName = competitionFile.getId();
        this.playersNeeded = competitionFile.getPlayersNeeded();
        this.startSound = competitionFile.getStartSound();
        this.timeLeft = this.maxDuration = (long)competitionFile.getDuration() * 60L;
        this.alertTimes = competitionFile.getAlertTimes();
        this.rewards = competitionFile.getRewards();
        this.competitionType = competitionFile.getType();
        this.numberNeeded = competitionFile.getNumberNeeded();
    }

    @NotNull
    private Bar createBossbar() {
        Bar bar = new Bar();
        bar.setShouldShow(this.competitionFile.shouldShowBossbar());
        bar.setColour(this.competitionFile.getBossbarColour());
        EMFSingleMessage prefix = this.competitionFile.getBossbarPrefix();
        if (this.selectedRarity != null) {
            prefix.setRarity(this.selectedRarity.getDisplayName());
        } else if (this.selectedFish != null) {
            prefix.setRarity(this.selectedFish.getRarity().getDisplayName());
            prefix.setVariable("{fish}", this.selectedFish.getDisplayName());
        }
        bar.setPrefix(prefix, this.competitionType);
        return bar;
    }

    public Competition(long duration, CompetitionType type) {
        this.maxDuration = duration;
        this.alertTimes = new ArrayList<Long>();
        this.rewards = new HashMap<Integer, List<Reward>>();
        this.competitionType = type;
    }

    public void setMaxDuration(int duration) {
        this.maxDuration = duration;
    }

    public void addTime(int durationSeconds) {
        this.maxDuration += (long)durationSeconds;
        this.timeLeft += (long)durationSeconds;
    }

    public static boolean isActive() {
        return Competition.getCurrentlyActive() != null;
    }

    public void setOriginallyRandom(boolean originallyRandom) {
        this.originallyRandom = originallyRandom;
    }

    @Nullable
    public static Competition getCurrentlyActive() {
        return active;
    }

    public void begin() {
        if (this.maxDuration <= 0L) {
            Logging.warn("Tried to start a competition with an invalid duration: " + this.competitionFile.getId());
            return;
        }
        try {
            if (!this.isAdminStarted() && EvenMoreFish.getInstance().getVisibleOnlinePlayers().size() < this.playersNeeded) {
                ConfigMessage.NOT_ENOUGH_PLAYERS.getMessage().broadcast();
                return;
            }
            if (!this.ended()) {
                active.end(false);
            }
            active = this;
            CompetitionStrategy strategy = this.competitionType.getStrategy();
            if (!strategy.begin(this)) {
                active = null;
                return;
            }
            this.leaderboard = new Leaderboard(this.competitionType);
            if (this.statusBar == null) {
                this.statusBar = this.createBossbar();
            }
            this.statusBar.show();
            this.initTimer();
            this.announceBegin();
            EMFCompetitionStartEvent startEvent = new EMFCompetitionStartEvent(this);
            Bukkit.getServer().getPluginManager().callEvent((Event)startEvent);
            Instant now = Instant.now();
            this.epochStartTime = now.getEpochSecond();
            this.startTime = LocalDateTime.ofInstant(now, ZoneId.systemDefault());
            this.getCompetitionFile().getStartCommands().forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
            EvenMoreFish.getInstance().getDecidedRarities().clear();
        }
        catch (Exception ex) {
            this.end(true);
        }
    }

    public void end(boolean startFail) {
        if (this.ended()) {
            return;
        }
        if (this.timingSystem != null) {
            this.timingSystem.stop();
        }
        if (this.statusBar != null) {
            this.statusBar.hide();
        }
        if (startFail) {
            active = null;
            return;
        }
        try {
            this.fireEndEvent();
            this.notifyPlayers();
            this.processRewards();
            this.resetCompetitionTypeIfRandom();
            this.updateDatabase();
            this.leaderboard.clear();
        }
        catch (Exception exception) {
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, "An exception was thrown while the competition was being ended!", exception);
        }
        finally {
            active = null;
        }
    }

    public boolean ended() {
        return active == null;
    }

    private void fireEndEvent() {
        EMFCompetitionEndEvent endEvent = new EMFCompetitionEndEvent(this);
        endEvent.callEvent();
    }

    private void notifyPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ConfigMessage.COMPETITION_END.getMessage().send((Audience)player);
            this.sendLeaderboard((CommandSender)player);
        }
    }

    private void processRewards() {
        if (this.competitionType.getStrategy().isSingleReward() && this.singleWinner != null) {
            this.singleReward(this.singleWinner);
        } else {
            this.handleRewards();
        }
    }

    private void resetCompetitionTypeIfRandom() {
        if (this.originallyRandom) {
            this.competitionType = CompetitionType.RANDOM;
        }
    }

    private void updateDatabase() {
        if (!DatabaseUtil.isDatabaseOnline()) {
            return;
        }
        EvenMoreFish plugin = EvenMoreFish.getInstance();
        plugin.getPluginDataManager().getCompetitionDataManager().update(this.competitionName, new CompetitionReport(this, this.startTime, LocalDateTime.now()));
    }

    private void initTimer() {
        CompetitionTimer timer = new CompetitionTimer(this);
        timer.start();
        this.timingSystem = timer;
    }

    private boolean processCompetitionSecond(long timeLeft) {
        if (this.alertTimes.contains(timeLeft)) {
            EMFMessage message = this.getTypeFormat(ConfigMessage.TIME_ALERT);
            message.broadcast();
        } else if (timeLeft <= 0L) {
            this.end(false);
            return true;
        }
        return false;
    }

    @NotNull
    private EMFMessage getTypeFormat(ConfigMessage configMessage) {
        return this.competitionType.getStrategy().getTypeFormat(this, configMessage);
    }

    protected boolean decreaseTime() {
        if (this.processCompetitionSecond(this.timeLeft)) {
            return true;
        }
        --this.timeLeft;
        return false;
    }

    public static boolean isDoingFirstPlaceActionBar() {
        boolean doActionBarMessage = MessageConfig.getInstance().getConfig().getBoolean("action-bar-message");
        List supportedTypes = MessageConfig.getInstance().getConfig().getStringList("action-bar-types");
        boolean isSupportedActionBarType = active != null && supportedTypes.contains(Competition.active.competitionType.toString());
        return doActionBarMessage && isSupportedActionBarType;
    }

    public void applyToLeaderboard(Fish fish, Player fisher) {
        this.competitionType.getStrategy().applyToLeaderboard(fish, fisher, this.leaderboard, this);
    }

    public void announceBegin() {
        this.startMessage = this.competitionType.getStrategy().getBeginMessage(this, this.competitionType);
        this.startMessage.broadcast();
        if (this.startSound != null) {
            Bukkit.getOnlinePlayers().forEach(player -> player.playSound(player.getLocation(), this.startSound, 10.0f, 1.0f));
        }
    }

    public void sendLeaderboard(@NotNull CommandSender sender) {
        if (!Competition.isActive()) {
            ConfigMessage.NO_COMPETITION_RUNNING.getMessage().send((Audience)sender);
            return;
        }
        if (this.leaderboard.getSize() == 0) {
            ConfigMessage.NO_FISH_CAUGHT.getMessage().send((Audience)sender);
            return;
        }
        List<String> competitionColours = this.competitionFile.getLeaderboardColours();
        List<CompetitionEntry> entries = this.leaderboard.getEntries();
        boolean isConsole = !(sender instanceof Player);
        EMFMessage leaderboardMessage = this.buildLeaderboardMessage(entries, competitionColours, isConsole);
        leaderboardMessage.send((Audience)sender);
        EMFMessage message = ConfigMessage.LEADERBOARD_TOTAL_PLAYERS.getMessage();
        message.setAmount(Integer.toString(this.leaderboard.getSize()));
        message.send((Audience)sender);
    }

    @NotNull
    private EMFMessage buildLeaderboardMessage(List<CompetitionEntry> entries, List<String> competitionColours, boolean isConsole) {
        if (entries == null) {
            entries = List.of();
        }
        int maxCount = MessageConfig.getInstance().getLeaderboardCount();
        EMFListMessage builder = EMFListMessage.empty();
        int pos = 0;
        for (CompetitionEntry entry : entries) {
            if (++pos > competitionColours.size() || pos > maxCount) break;
            EMFMessage message = isConsole ? this.competitionType.getStrategy().getSingleConsoleLeaderboardMessage(entry) : this.competitionType.getStrategy().getSinglePlayerLeaderboard(entry);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry.getPlayer());
            String name = player.getName() == null ? "Unknown" : player.getName();
            EMFSingleMessage colour = EMFSingleMessage.fromString(competitionColours.get(pos - 1));
            colour.setVariable("{name}", name);
            message.setVariable("{pos_colour}", "");
            message.setVariable("{player}", colour);
            message.setPlayer(player);
            message.setPosition(Integer.toString(pos));
            message.setRarity(entry.getFish().getRarity().getDisplayName());
            message.setFishCaught(entry.getFish().getDisplayName());
            builder.appendMessage(message);
        }
        return builder;
    }

    private void handleDatabaseUpdates(CompetitionEntry entry, boolean isTopEntry) {
        if (!DatabaseUtil.isDatabaseOnline()) {
            return;
        }
        UserReport userReport = EvenMoreFish.getInstance().getPluginDataManager().getUserReportDataManager().get(String.valueOf(entry.getPlayer()));
        if (userReport == null) {
            EvenMoreFish.getInstance().getLogger().severe("Could not fetch User Report for " + String.valueOf(entry.getPlayer()) + ", their data has not been modified.");
            return;
        }
        if (isTopEntry) {
            userReport.incrementCompetitionsWon(1);
        }
        userReport.incrementCompetitionsJoined(1);
    }

    private void handleRewards() {
        if (this.leaderboard.getSize() == 0) {
            if (this.competitionType != CompetitionType.SPECIFIC_FISH && this.competitionType != CompetitionType.SPECIFIC_RARITY || this.numberNeeded != 1) {
                ConfigMessage.NO_WINNERS.getMessage().broadcast();
            }
            return;
        }
        int rewardPlace = 1;
        List<CompetitionEntry> entries = this.leaderboard.getEntries();
        if (DatabaseUtil.isDatabaseOnline() && !entries.isEmpty()) {
            this.handleDatabaseUpdates(this.leaderboard.getTopEntry(), true);
        }
        for (CompetitionEntry entry : entries) {
            Player player = Bukkit.getPlayer((UUID)entry.getPlayer());
            if (player == null) {
                ++rewardPlace;
                continue;
            }
            if (this.rewards.containsKey(rewardPlace)) {
                this.rewards.get(rewardPlace).forEach(reward -> reward.rewardPlayer(player, null));
            } else {
                List<Reward> participation = this.rewards.get(-1);
                if (participation != null) {
                    participation.forEach(reward -> reward.rewardPlayer(player, null));
                }
            }
            this.handleDatabaseUpdates(entry, false);
            ++rewardPlace;
        }
    }

    private void singleReward(Player player) {
        EMFMessage message = this.getTypeFormat(ConfigMessage.COMPETITION_SINGLE_WINNER);
        message.setPlayer((OfflinePlayer)player);
        message.setCompetitionType(this.competitionType.getTypeVariable().getMessage());
        message.broadcast();
        if (!this.rewards.isEmpty()) {
            for (Reward reward : this.rewards.get(1)) {
                reward.rewardPlayer(player, null);
            }
        }
    }

    @NotNull
    public Bar getStatusBar() {
        return this.statusBar;
    }

    @NotNull
    public CompetitionType getCompetitionType() {
        return this.competitionType;
    }

    public void setNumberNeeded(int numberNeeded) {
        this.numberNeeded = numberNeeded;
    }

    public int getLeaderboardSize() {
        return this.leaderboard.getSize();
    }

    @NotNull
    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    @Nullable
    public EMFMessage getStartMessage() {
        return this.startMessage;
    }

    @NotNull
    public String getCompetitionName() {
        return this.competitionName;
    }

    @NotNull
    public CompetitionFile getCompetitionFile() {
        return this.competitionFile;
    }

    @NotNull
    public static EMFMessage getNextCompetitionMessage() {
        if (Competition.isActive()) {
            return ConfigMessage.PLACEHOLDER_TIME_REMAINING_DURING_COMP.getMessage();
        }
        long remainingTime = Competition.getRemainingTime();
        EMFMessage message = ConfigMessage.PLACEHOLDER_TIME_REMAINING.getMessage();
        message.setDays(Long.toString(remainingTime / 1440L));
        message.setHours(Long.toString(remainingTime % 1440L / 60L));
        message.setMinutes(Long.toString(remainingTime % 1440L % 60L % 60L));
        return message;
    }

    private static long getRemainingTime() {
        long startTime = EvenMoreFish.getInstance().getCompetitionQueue().getNextCompetition().toMillis();
        long currentTime = System.currentTimeMillis();
        return Duration.ofMillis(startTime - currentTime).toMinutes();
    }

    public void setCompetitionType(CompetitionType competitionType) {
        this.competitionType = competitionType;
    }

    @Nullable
    public Fish getSelectedFish() {
        return this.selectedFish;
    }

    @Nullable
    public Rarity getSelectedRarity() {
        return this.selectedRarity;
    }

    public int getNumberNeeded() {
        return this.numberNeeded;
    }

    public boolean isAdminStarted() {
        return this.adminStarted;
    }

    public void setAdminStarted(boolean adminStarted) {
        this.adminStarted = adminStarted;
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public boolean chooseFish() {
        List<Rarity> configRarities = this.getAllowedRaritiesOrLog();
        if (configRarities == null) {
            return false;
        }
        Logger logger = EvenMoreFish.getInstance().getLogger();
        ArrayList<Fish> fishPool = new ArrayList<Fish>();
        for (Rarity rarity : configRarities) {
            fishPool.addAll(rarity.getOriginalFishList());
        }
        if (fishPool.isEmpty()) {
            logger.severe("No fish available in allowed rarities for " + this.getCompetitionName());
            return false;
        }
        try {
            Fish selectedFish = FishManager.getInstance().getRandomWeightedFish(fishPool, 1.0, null);
            if (selectedFish == null) {
                throw new IllegalArgumentException("No fish selected from pool");
            }
            this.selectedFish = selectedFish;
            return true;
        }
        catch (Exception e) {
            logger.severe(() -> "Could not load: " + this.getCompetitionName() + " because a random fish could not be chosen.");
            logger.severe(() -> "fishPool.size(): " + fishPool.size());
            logger.severe(() -> "configRarities.size(): " + configRarities.size());
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public boolean chooseRarity() {
        List<Rarity> configRarities = this.getAllowedRaritiesOrLog();
        if (configRarities == null) {
            return false;
        }
        Logger logger = EvenMoreFish.getInstance().getLogger();
        try {
            Rarity rarity = configRarities.get(EvenMoreFish.getInstance().getRandom().nextInt(configRarities.size()));
            if (rarity == null) {
                rarity = FishManager.getInstance().getRandomWeightedRarity(null, 0.0, Collections.emptySet(), Set.copyOf(FishManager.getInstance().getRarityMap().values()), null);
            }
            if (rarity == null) {
                logger.severe("No rarity could be chosen for " + this.getCompetitionName());
                return false;
            }
            this.selectedRarity = rarity;
            return true;
        }
        catch (Exception e) {
            logger.severe("Could not load: " + this.getCompetitionName() + " because a random rarity could not be chosen.");
            logger.severe(() -> "rarityMap.size(): " + FishManager.getInstance().getRarityMap().size());
            logger.severe(() -> "configRarities.size(): " + configRarities.size());
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public void setSingleWinner(@Nullable Player player) {
        this.singleWinner = player;
    }

    private List<Rarity> getAllowedRaritiesOrLog() {
        List<Rarity> configRarities = this.getCompetitionFile().getAllowedRarities();
        if (configRarities.isEmpty()) {
            EvenMoreFish.getInstance().getLogger().severe("No allowed-rarities list found in " + this.getCompetitionFile().getFileName() + " competition config file.");
            return null;
        }
        return configRarities;
    }
}

