/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.AbstractFileBasedManager;
import com.oheers.fish.competition.configs.CompetitionConversions;
import com.oheers.fish.competition.configs.CompetitionFile;
import com.oheers.fish.fishing.rods.RodManager;
import com.oheers.fish.utils.TimeCode;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompetitionQueue
extends AbstractFileBasedManager<CompetitionFile> {
    private final TreeMap<TimeCode, CompetitionFile> competitions = new TreeMap(TimeCode.getComparator());

    public CompetitionQueue() {
        super(RodManager.getInstance());
    }

    @Override
    protected void performPreLoadConversions() {
        new CompetitionConversions().performCheck();
    }

    @Override
    protected void loadItems() {
        this.loadItemsFromFiles("competitions", CompetitionFile::new, CompetitionFile::getId, CompetitionFile::isDisabled);
        this.competitions.clear();
        this.getItemMap().values().forEach(file -> {
            if (this.loadSpecificDayTimes((CompetitionFile)file)) {
                return;
            }
            if (this.loadRepeatedTiming((CompetitionFile)file)) {
                return;
            }
            EvenMoreFish.getInstance().debug(Level.WARNING, file.getFile().getName() + "'s timings are not configured properly. This competition will never automatically start.");
        });
    }

    @Override
    protected void logLoadedItems() {
        EvenMoreFish.getInstance().getLogger().info("Loaded " + this.getItemMap().size() + " competition file(s) and " + this.competitions.size() + " scheduled competitions.");
    }

    public Map<TimeCode, CompetitionFile> getCompetitions() {
        return this.competitions;
    }

    private boolean loadSpecificDayTimes(@NotNull CompetitionFile file) {
        Map<DayOfWeek, List<String>> scheduledDays = file.getScheduledDays();
        if (scheduledDays.isEmpty()) {
            return false;
        }
        scheduledDays.forEach((day, times) -> times.forEach(time -> this.competitions.put(this.generateTimeCode((DayOfWeek)day, (String)time), file)));
        return true;
    }

    private boolean loadRepeatedTiming(@NotNull CompetitionFile file) {
        List<String> repeatedTimes = file.getTimes();
        if (repeatedTimes.isEmpty()) {
            return false;
        }
        ArrayList<DayOfWeek> daysToUse = new ArrayList<DayOfWeek>(Arrays.asList(DayOfWeek.values()));
        daysToUse.removeAll(file.getBlacklistedDays());
        for (String time : repeatedTimes) {
            for (DayOfWeek day : daysToUse) {
                this.competitions.put(this.generateTimeCode(day, time), file);
            }
        }
        return true;
    }

    @Nullable
    public TimeCode generateTimeCode(@NotNull DayOfWeek day, @NotNull String hourMinute) {
        String[] time = hourMinute.split(":");
        if (time.length != 2) {
            return null;
        }
        Integer hour = FishUtils.getInteger(time[0]);
        Integer minute = FishUtils.getInteger(time[1]);
        if (hour == null || minute == null) {
            return null;
        }
        return TimeCode.exact(day, hour, minute);
    }

    public int getSize() {
        return this.competitions.size();
    }

    public TimeCode getNextCompetition() {
        TimeCode now = TimeCode.now();
        if (this.competitions.containsKey(now)) {
            return now;
        }
        this.competitions.put(now, null);
        TimeCode nextCode = this.findNextCode(now);
        this.competitions.remove(now);
        return nextCode;
    }

    private TimeCode findNextCode(@NotNull TimeCode now) {
        ArrayList<TimeCode> timeCodes = new ArrayList<TimeCode>(this.competitions.keySet());
        int position = timeCodes.indexOf(now);
        if (position == this.competitions.size() - 1) {
            return (TimeCode)timeCodes.get(0);
        }
        return (TimeCode)timeCodes.get(position + 1);
    }
}

