/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.FishUtils;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionEntry;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.leaderboard.Leaderboard;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.text.DecimalFormat;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface CompetitionStrategy {
    public boolean randomInit(@NotNull Competition var1);

    default public boolean begin(Competition competition) {
        return true;
    }

    public void applyToLeaderboard(Fish var1, Player var2, Leaderboard var3, Competition var4);

    default public EMFMessage getBeginMessage(Competition competition, CompetitionType type) {
        EMFMessage message = ConfigMessage.COMPETITION_START.getMessage();
        message.setCompetitionType(type.getTypeVariable().getMessage());
        return message;
    }

    public EMFMessage getSingleConsoleLeaderboardMessage(@NotNull CompetitionEntry var1);

    public EMFMessage getSinglePlayerLeaderboard(@NotNull CompetitionEntry var1);

    @NotNull
    default public EMFMessage getTypeFormat(@NotNull Competition competition, ConfigMessage configMessage) {
        EMFMessage message = configMessage.getMessage();
        message.setTimeFormatted(FishUtils.timeFormat(competition.getTimeLeft()));
        message.setTimeRaw(FishUtils.timeRaw(competition.getTimeLeft()));
        message.setCompetitionType(competition.getCompetitionType().getTypeVariable().getMessage());
        return message;
    }

    default public DecimalFormat getDecimalFormat() {
        return new DecimalFormat("#.0");
    }

    public boolean shouldUseFishLength();

    public boolean isSingleReward();
}

