/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition.strategies;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionEntry;
import com.oheers.fish.competition.CompetitionStrategy;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.leaderboard.Leaderboard;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpecificFishStrategy
implements CompetitionStrategy {
    @Override
    public boolean randomInit(@NotNull Competition competition) {
        return competition.getNumberNeeded() > 0 && competition.chooseFish();
    }

    @Override
    public boolean begin(Competition competition) {
        if (!competition.chooseFish()) {
            EvenMoreFish.getInstance().getLogger().warning("Failed to select a fish for " + competition.getCompetitionFile().getId() + " competition.");
            return false;
        }
        if (competition.getNumberNeeded() == 0) {
            EvenMoreFish.getInstance().getLogger().warning(competition.getCompetitionFile().getId() + " competition does not have number-needed set. Defaulting to 1.");
            competition.setNumberNeeded(1);
        }
        if (competition.getSelectedFish() == null) {
            EvenMoreFish.getInstance().getLogger().warning("Failed to select a fish for " + competition.getCompetitionFile().getId() + " competition.");
            return false;
        }
        return true;
    }

    @Override
    public void applyToLeaderboard(Fish fish, Player fisher, Leaderboard leaderboard, Competition competition) {
        Fish selected = competition.getSelectedFish();
        if (selected != null && !fish.equals(selected)) {
            return;
        }
        CompetitionEntry entry = leaderboard.getEntry(fisher.getUniqueId());
        if (entry != null) {
            entry = leaderboard.trackFish(entry, fish);
        } else {
            entry = new CompetitionEntry(fisher.getUniqueId(), fish, competition.getCompetitionType());
            leaderboard.addEntry(entry);
        }
        if (entry.getValue() >= (float)competition.getNumberNeeded()) {
            competition.setSingleWinner(fisher);
            competition.end(false);
        }
    }

    @Override
    @NotNull
    public EMFMessage getTypeFormat(@NotNull Competition competition, ConfigMessage configMessage) {
        Fish selectedFish = competition.getSelectedFish();
        EMFMessage message = CompetitionStrategy.super.getTypeFormat(competition, configMessage);
        message.setAmount(Integer.toString(competition.getNumberNeeded()));
        if (selectedFish != null) {
            message.setRarity(selectedFish.getRarity().getDisplayName());
            message.setFishCaught(selectedFish.getDisplayName());
        }
        return message;
    }

    @Override
    public EMFMessage getBeginMessage(@NotNull Competition competition, CompetitionType type) {
        return this.getTypeFormat(competition, ConfigMessage.COMPETITION_START);
    }

    @Override
    public EMFMessage getSingleConsoleLeaderboardMessage(@NotNull CompetitionEntry entry) {
        EMFMessage message = ConfigMessage.LEADERBOARD_MOST_FISH.getMessage();
        message.setAmount((int)entry.getValue());
        return message;
    }

    @Override
    public EMFMessage getSinglePlayerLeaderboard(@NotNull CompetitionEntry entry) {
        EMFMessage message = ConfigMessage.LEADERBOARD_MOST_FISH.getMessage();
        message.setAmount((int)entry.getValue());
        return message;
    }

    @Override
    public boolean shouldUseFishLength() {
        return false;
    }

    @Override
    public boolean isSingleReward() {
        return true;
    }
}

