/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database;

import com.oheers.fish.competition.Competition;
import com.oheers.fish.database.model.CompetitionReport;
import com.oheers.fish.database.model.fish.FishLog;
import com.oheers.fish.database.model.fish.FishStats;
import com.oheers.fish.database.model.user.UserFishStats;
import com.oheers.fish.database.model.user.UserReport;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.Rarity;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;

public interface DatabaseAPI {
    public boolean hasUser(@NotNull UUID var1);

    public int getUserId(@NotNull UUID var1);

    public UserReport getUserReport(@NotNull UUID var1);

    public boolean hasFishStats(@NotNull Fish var1);

    public void incrementFish(@NotNull Fish var1);

    public boolean userHasFish(@NotNull Fish var1, @NotNull HumanEntity var2);

    public boolean userHasRarity(@NotNull Rarity var1, @NotNull HumanEntity var2);

    public boolean userHasFish(@NotNull String var1, @NotNull String var2, int var3);

    public boolean userHasRarity(@NotNull String var1, int var2);

    public void createCompetitionReport(@NotNull Competition var1);

    public void createSale(@NotNull String var1, @NotNull String var2, @NotNull String var3, int var4, double var5, double var7);

    public void createTransaction(@NotNull String var1, int var2, @NotNull Timestamp var3);

    public UserFishStats getUserFishStats(int var1, String var2, String var3);

    public FishLog getFishLog(int var1, String var2, String var3, LocalDateTime var4);

    public Set<FishLog> getFishLogEntries(int var1, String var2, String var3);

    public void setFishLogEntry(FishLog var1);

    public FishStats getFishStats(String var1, String var2);

    public void upsertFishStats(FishStats var1);

    public void batchInsertFishLogs(Collection<FishLog> var1);

    public Integer upsertUserReport(UserReport var1);

    public void batchUpdateUserFishStats(Collection<UserFishStats> var1);

    public void updateCompetition(CompetitionReport var1);

    public CompetitionReport getCompetitionReport(int var1);

    public void batchUpdateCompetitions(Collection<CompetitionReport> var1);
}

