/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.connection;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.libs.hikaricp.hikari.HikariConfig;
import com.oheers.fish.libs.hikaricp.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionFactory {
    protected HikariDataSource dataSource;
    private final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private Boolean supportsTransaction;

    protected abstract void configureDatabase(HikariConfig var1, String var2, int var3, String var4, String var5, String var6);

    private String getDatabaseAddress() {
        return MainConfig.getInstance().getAddress().split(":")[0];
    }

    private int getDatabasePort() {
        if (!MainConfig.getInstance().getAddress().contains(":")) {
            return 3306;
        }
        try {
            return Integer.parseInt(MainConfig.getInstance().getAddress().split(":")[1]);
        }
        catch (NumberFormatException e) {
            return 3306;
        }
    }

    public void init() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("evenmorefish-hikari");
        this.configureDatabase(config, this.getDatabaseAddress(), this.getDatabasePort(), MainConfig.getInstance().getDatabase(), MainConfig.getInstance().getUsername(), MainConfig.getInstance().getPassword());
        config.setInitializationFailTimeout(-1L);
        config.setValidationTimeout(5000L);
        config.addDataSourceProperty("validateBorrowedConnections", true);
        config.setLeakDetectionThreshold(30000L);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.overrideProperties(properties);
        this.setProperties(config, properties);
        this.initDriver();
        this.dataSource = new HikariDataSource(config);
        this.logger.info("Connected to database!");
    }

    protected void overrideProperties(@NotNull Map<String, String> properties) {
        properties.putIfAbsent("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    }

    protected void setProperties(HikariConfig config, @NotNull Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            config.addDataSourceProperty(property.getKey(), property.getValue());
        }
    }

    public void shutdown() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public abstract String getType();

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Null data source");
        }
        Connection connection = this.dataSource.getConnection();
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        return connection;
    }

    public String getDriverClass() {
        return "";
    }

    protected void initDriver() {
        if (this.getDriverClass().isEmpty()) {
            return;
        }
        try {
            Class.forName(this.getDriverClass());
        }
        catch (ClassNotFoundException e) {
            EvenMoreFish.getInstance().getLogger().severe("Tried to init driver: %s, but could not find it.".formatted(this.getDriverClass()));
        }
    }

    public boolean supportsTransactions() {
        if (this.supportsTransaction != null) {
            return this.supportsTransaction;
        }
        try (Connection connection = this.getConnection();){
            this.supportsTransaction = connection.getMetaData().supportsTransactions();
        }
        catch (SQLException e) {
            EvenMoreFish.getInstance().getLogger().log(Level.WARNING, "Failed to check transaction support, assuming false", e);
            this.supportsTransaction = false;
        }
        return this.supportsTransaction;
    }
}

