/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.connection;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.utils.ManifestUtil;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.database.migrate.LegacyToV3DatabaseMigration;
import com.oheers.fish.database.strategies.DatabaseStrategyFactory;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.SelectFieldOrAsterisk;
import com.oheers.fish.libs.jooq.conf.MappedSchema;
import com.oheers.fish.libs.jooq.conf.MappedTable;
import com.oheers.fish.libs.jooq.conf.RenderMapping;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.exception.DataAccessException;
import com.oheers.fish.libs.jooq.impl.DSL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.command.CommandSender;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationManager {
    private final String latestBaselineVersion;
    private final Logger logger = LoggerFactory.getLogger(MigrationManager.class.getName());
    private final FluentConfiguration baseFlywayConfiguration;
    private final Flyway defaultFlyway;
    private final ConnectionFactory connectionFactory;
    private final Settings migrationSettings;

    public MigrationManager(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.baseFlywayConfiguration = this.getBaseFlywayConfiguration(connectionFactory);
        this.defaultFlyway = this.baseFlywayConfiguration.load();
        this.latestBaselineVersion = ManifestUtil.getAttributeFromManifest("Database-Baseline-Version", "8.1");
        this.migrationSettings = new Settings();
        this.migrationSettings.setExecuteLogging(true);
        this.migrationSettings.withRenderMapping(new RenderMapping().withSchemata(new MappedSchema().withInput("").withOutput(MainConfig.getInstance().getDatabase()).withTables(new MappedTable().withInputExpression(Pattern.compile("\\$\\{table.prefix}(.*)")).withOutput(MainConfig.getInstance().getPrefix() + "$1"))));
        DatabaseUtil.debugDatabaseTypeVersion(this.connectionFactory);
    }

    public void migrateFromVersion(String currentDbVersion, boolean baseline) {
        Flyway migrate = this.baseFlywayConfiguration.baselineVersion(this.latestBaselineVersion).load();
        try {
            if (this.shouldBaseline(baseline, this.latestBaselineVersion, currentDbVersion)) {
                migrate.baseline();
            }
            migrate.migrate();
        }
        catch (FlywayException e) {
            this.logger.error("Database migration failed for version: {}", (Object)currentDbVersion, (Object)e);
        }
    }

    private boolean shouldBaseline(boolean baseline, String baselineVersion, String currentDbVersion) {
        if (!baseline) {
            return false;
        }
        ComparableVersion version1 = new ComparableVersion(baselineVersion);
        ComparableVersion version2 = new ComparableVersion(currentDbVersion);
        int compare = version1.compareTo(version2);
        return compare == 0;
    }

    public boolean usingV2() {
        boolean dataFolder = Files.isDirectory(Paths.get(String.valueOf(EvenMoreFish.getInstance().getDataFolder()) + "/data/", new String[0]), new LinkOption[0]);
        return dataFolder || this.queryTableExistence("Fish2");
    }

    public boolean queryTableExistence(String tableName) {
        boolean bl;
        block8: {
            Connection connection = this.connectionFactory.getConnection();
            try {
                DSLContext dsl = DSL.using(connection, this.migrationSettings);
                bl = dsl.fetchExists(DSL.select(new SelectFieldOrAsterisk[0]).from("information_schema.tables").where(DSL.field("table_name").eq(tableName)).and(DSL.noCondition()));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DataAccessException | SQLException e) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void dropFlywaySchemaHistory() {
        try (Connection connection = this.defaultFlyway.getConfiguration().getDataSource().getConnection();
             PreparedStatement statement = connection.prepareStatement("DROP TABLE IF EXISTS flyway_schema_history");){
            statement.execute();
            this.logger.info("Dropped flyway schema history table.");
        }
        catch (SQLException e) {
            this.logger.error("Failed to drop Flyway schema history table", e);
        }
    }

    public void repairFlyway() {
        this.baseFlywayConfiguration.load().repair();
    }

    public void cleanFlyway() {
        this.baseFlywayConfiguration.load().clean();
    }

    public MigrationVersion getDatabaseVersion() {
        MigrationVersion latestBaseVersion = MigrationVersion.fromVersion((String)this.latestBaselineVersion);
        try (Connection ignored = this.connectionFactory.getConnection();){
            EvenMoreFish.getInstance().debug("Attempting first connection to database...");
        }
        catch (SQLException e) {
            return latestBaseVersion;
        }
        MigrationInfoService infoService = this.baseFlywayConfiguration.load().info();
        if (infoService.current() == null) {
            return latestBaseVersion;
        }
        return this.baseFlywayConfiguration.load().info().current().getVersion();
    }

    public void migrateFromV6ToLatest() {
        Flyway flyway = this.baseFlywayConfiguration.baselineVersion("6").load();
        try {
            flyway.migrate();
        }
        catch (FlywayException e) {
            this.logger.error("There was a problem migrating to the latest database version. You may experience issues.", e);
        }
    }

    public void legacyFlywayBaseline() {
        Flyway flyway = this.baseFlywayConfiguration.target("3.1").load();
        flyway.migrate();
    }

    public void legacyInitVersion() {
        Flyway flyway = this.baseFlywayConfiguration.target("3.0").load();
        flyway.migrate();
    }

    public void migrateFromV5ToLatest() {
        Flyway flyway = this.baseFlywayConfiguration.baselineVersion("5").load();
        try {
            this.dropFlywaySchemaHistory();
            flyway.migrate();
        }
        catch (FlywayException e) {
            this.logger.error("There was a problem migrating to the latest database version. You may experience issues.", e);
        }
    }

    @Contract(pure=true)
    @NotNull
    private String getMigrationLocation(String dialect) {
        return "db/migrations/" + dialect;
    }

    public void migrateLegacy(CommandSender initiator) {
        LegacyToV3DatabaseMigration legacy = new LegacyToV3DatabaseMigration(EvenMoreFish.getInstance().getPluginDataManager().getDatabase(), this, this.connectionFactory);
        legacy.migrate(initiator);
    }

    private FluentConfiguration getBaseFlywayConfiguration(@NotNull ConnectionFactory connectionFactory) {
        FluentConfiguration baseConfig = Flyway.configure((ClassLoader)this.getClass().getClassLoader()).dataSource((DataSource)connectionFactory.dataSource).placeholders(Map.of("table.prefix", MainConfig.getInstance().getPrefix(), "db.name", MainConfig.getInstance().getDatabase())).createSchemas(true).locations(new String[]{this.getMigrationLocation(MainConfig.getInstance().getDatabaseType())}).validateMigrationNaming(true).baselineOnMigrate(true).table(MainConfig.getInstance().getPrefix() + "flyway_schema_history");
        return DatabaseStrategyFactory.getStrategy(connectionFactory).configureFlyway(baseConfig);
    }

    public Settings getMigrationSettings() {
        return this.migrationSettings;
    }
}

