/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.data;

import com.oheers.fish.fishing.items.Fish;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

public class FishLogKey {
    private int userId;
    private String fishName;
    private String fishRarity;
    private LocalDateTime dateTime;

    public FishLogKey(int userId, String fishName, String fishRarity, LocalDateTime dateTime) {
        this.userId = userId;
        this.fishName = fishName;
        this.fishRarity = fishRarity;
        this.dateTime = dateTime;
    }

    public FishLogKey(int userId, Fish fish, LocalDateTime dateTime) {
        this.userId = userId;
        this.fishName = fish.getName();
        this.fishRarity = fish.getRarity().getId();
        this.dateTime = dateTime;
    }

    @NotNull
    public static FishLogKey of(int userId, String fishName, String fishRarity, LocalDateTime dateTime) {
        return new FishLogKey(userId, fishName, fishRarity, dateTime);
    }

    @NotNull
    public static FishLogKey from(String pattern) {
        String[] split = pattern.split("\\.");
        return new FishLogKey(Integer.parseInt(split[0]), split[1], split[2], LocalDateTime.parse(split[3]));
    }

    @NotNull
    public static FishLogKey of(int userId, @NotNull Fish fish, LocalDateTime dateTime) {
        return new FishLogKey(userId, fish, dateTime);
    }

    public String toString() {
        return this.userId + "." + this.fishName + "." + this.fishRarity + "." + this.dateTime.toString();
    }

    public String toStringDefault() {
        return "FishLogKey{userId=" + this.userId + ", fishName='" + this.fishName + "', fishRarity='" + this.fishRarity + "', dateTime=" + String.valueOf(this.dateTime) + "}";
    }

    public int getUserId() {
        return this.userId;
    }

    public String getFishName() {
        return this.fishName;
    }

    public String getFishRarity() {
        return this.fishRarity;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }
}

