/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.data;

import com.oheers.fish.fishing.items.Fish;
import org.jetbrains.annotations.NotNull;

public class UserFishRarityKey {
    private final int userId;
    private final String fishName;
    private final String fishRarity;

    public UserFishRarityKey(int userId, String fishName, String fishRarity) {
        this.userId = userId;
        this.fishName = fishName;
        this.fishRarity = fishRarity;
    }

    @NotNull
    public static UserFishRarityKey of(int userId, String fishName, String fishRarity) {
        return new UserFishRarityKey(userId, fishName, fishRarity);
    }

    @NotNull
    public static UserFishRarityKey of(int userId, @NotNull Fish fish) {
        return new UserFishRarityKey(userId, fish.getName(), fish.getRarity().getId());
    }

    @NotNull
    public static UserFishRarityKey from(@NotNull String pattern) {
        String[] parts = pattern.split("\\.");
        if (parts.length != 3) {
            return UserFishRarityKey.empty();
        }
        try {
            int userId = Integer.parseInt(parts[0]);
            String fishName = parts[1];
            String fishRarity = parts[2];
            return new UserFishRarityKey(userId, fishName, fishRarity);
        }
        catch (NumberFormatException e) {
            return UserFishRarityKey.empty();
        }
    }

    @NotNull
    public static UserFishRarityKey empty() {
        return new UserFishRarityKey(-1, "", "");
    }

    public int getUserId() {
        return this.userId;
    }

    public String getFishName() {
        return this.fishName;
    }

    public String getFishRarity() {
        return this.fishRarity;
    }

    public String toString() {
        return this.userId + "." + this.fishName + "." + this.fishRarity;
    }

    public String toStringDefault() {
        return "UserFishRarityKey{userId='" + this.userId + "'fishName='" + this.fishName + "', fishRarity='" + this.fishRarity + "'}";
    }
}

