/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.data.manager;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.database.data.strategy.DataSavingStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class DataManager<T> {
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();
    private final DataSavingStrategy<T> savingStrategy;
    private final Function<String, T> defaultLoader;

    public DataManager(DataSavingStrategy<T> savingStrategy, Function<String, T> defaultLoader) {
        this.savingStrategy = savingStrategy;
        this.defaultLoader = defaultLoader;
    }

    public T get(String key, Function<String, T> loader) {
        return (T)this.cache.computeIfAbsent(key, k -> {
            Object data = loader.apply((String)k);
            if (data != null) {
                this.savingStrategy.save(data);
            }
            return data;
        });
    }

    public T getOrCreate(String key, Function<String, T> loader, Supplier<T> fallbackValueSupplier) {
        T loadedValue = this.get(key, loader);
        if (loadedValue != null) {
            EvenMoreFish.getInstance().debug("Using loaded value.");
            return loadedValue;
        }
        T cachedValue = this.cache.get(key);
        if (cachedValue != null) {
            EvenMoreFish.getInstance().debug("Using cached value.");
            return cachedValue;
        }
        T fallbackValue = fallbackValueSupplier.get();
        if (fallbackValue != null) {
            this.cache.put(key, fallbackValue);
            this.savingStrategy.save(fallbackValue);
            EvenMoreFish.getInstance().debug("Using fallback value.");
        }
        return fallbackValue;
    }

    public T get(String key) {
        if (this.defaultLoader == null) {
            throw new IllegalStateException("No default loader configured");
        }
        return this.get(key, this.defaultLoader);
    }

    public void update(String key, T data) {
        this.cache.put(key, data);
        this.savingStrategy.save(data);
    }

    public void updateAll(Map<String, T> data) {
        this.cache.putAll(data);
        this.savingStrategy.saveAll(data.values());
    }

    public void flush() {
        this.savingStrategy.saveAll(this.cache.values());
    }
}

