/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.events.EMFFishCaughtEvent;
import com.oheers.fish.api.events.EMFFishHuntEvent;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.data.FishRarityKey;
import com.oheers.fish.database.data.UserFishRarityKey;
import com.oheers.fish.database.data.manager.DataManager;
import com.oheers.fish.database.model.fish.FishLog;
import com.oheers.fish.database.model.fish.FishStats;
import com.oheers.fish.database.model.user.UserFishStats;
import com.oheers.fish.database.model.user.UserReport;
import com.oheers.fish.fishing.items.Fish;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class EMFFishListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEMFFishCatch(EMFFishCaughtEvent event) {
        this.handleFishEvent(event.getPlayer(), (Fish)event.getFish(), event.getCatchTime());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEMFFishHunt(EMFFishHuntEvent event) {
        this.handleFishEvent(event.getPlayer(), (Fish)event.getFish(), event.getHuntTime());
    }

    private void handleFishEvent(Player player, Fish fish, LocalDateTime catchTime) {
        if (!DatabaseUtil.isDatabaseOnline()) {
            return;
        }
        int userId = EvenMoreFish.getInstance().getPluginDataManager().getUserManager().getUserId(player.getUniqueId());
        this.handleFishLog(userId, fish, catchTime);
        this.handleUserFishStats(userId, fish);
        this.handleFishStats(fish);
        this.handleUserReport(player.getUniqueId(), fish);
    }

    private void handleUserReport(UUID uuid, Fish fish) {
        DataManager<UserReport> userReportDataManager = EvenMoreFish.getInstance().getPluginDataManager().getUserReportDataManager();
        UserReport userReport = userReportDataManager.get(String.valueOf(uuid), key -> EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getUserReport(uuid));
        if (userReport.getShortestLength() == -1.0f || userReport.getShortestLength() > fish.getLength()) {
            userReport.setShortestLengthAndFish(fish);
        }
        if (userReport.getLargestLength() < fish.getLength()) {
            userReport.setLongestLengthAndFish(fish);
        }
        if (userReport.getFirstFish().toString().equals(".")) {
            userReport.setFirstFish(FishRarityKey.of(fish));
        }
        userReport.setRecentFish(FishRarityKey.of(fish));
        userReport.incrementFishCaught(1);
        userReport.incrementTotalLength(fish.getLength());
        userReportDataManager.update(String.valueOf(uuid), userReport);
        EvenMoreFish.getInstance().debug("Saving user report %s".formatted(userReport.toString()));
    }

    private void handleFishStats(@NotNull Fish fish) {
        FishRarityKey fishRarityKey;
        DataManager<FishStats> fishStatsDataManager = EvenMoreFish.getInstance().getPluginDataManager().getFishStatsDataManager();
        FishStats stats = fishStatsDataManager.getOrCreate((fishRarityKey = FishRarityKey.of(fish)).toString(), key -> EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getFishStats(fish.getName(), fish.getRarity().getId()), () -> FishStats.empty(fish, LocalDateTime.now()));
        if (stats.getLongestLength() < fish.getLength()) {
            stats.setLongestLength(fish.getLength());
            stats.setLongestFisher(fish.getFisherman());
        }
        if (stats.getShortestLength() > fish.getLength()) {
            stats.setShortestLength(fish.getLength());
            stats.setShortestFisher(fish.getFisherman());
        }
        stats.incrementQuantity();
        fishStatsDataManager.update(fishRarityKey.toString(), stats);
        EvenMoreFish.getInstance().debug("Fish Stats: %s".formatted(stats.toString()));
    }

    private void handleFishLog(int userId, Fish fish, LocalDateTime catchTime) {
        DataManager<Collection<FishLog>> fishLogDataManager = EvenMoreFish.getInstance().getPluginDataManager().getFishLogDataManager();
        String competitionId = Competition.getCurrentlyActive() != null ? Competition.getCurrentlyActive().getCompetitionName() : null;
        FishLog log = new FishLog(userId, fish, catchTime, competitionId);
        String key = UserFishRarityKey.of(userId, fish).toString();
        fishLogDataManager.update(key, Collections.singletonList(log));
    }

    private void handleUserFishStats(int userId, @NotNull Fish fish) {
        DataManager<UserFishStats> userFishStatsDataManager = EvenMoreFish.getInstance().getPluginDataManager().getUserFishStatsDataManager();
        UserFishStats stats = userFishStatsDataManager.getOrCreate(UserFishRarityKey.of(userId, fish).toString(), id -> EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getUserFishStats(userId, fish.getName(), fish.getRarity().getId()), () -> new UserFishStats(userId, fish, LocalDateTime.now()));
        if (stats.getLongestLength() < fish.getLength()) {
            stats.setLongestLength(fish.getLength());
        }
        if (stats.getShortestLength() > fish.getLength()) {
            stats.setShortestLength(fish.getLength());
        }
        stats.incrementQuantity();
        String key = UserFishRarityKey.of(userId, fish).toString();
        userFishStatsDataManager.update(key, stats);
    }
}

