/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing;

import com.oheers.fish.FishUtils;
import com.oheers.fish.api.events.EMFFishHuntEvent;
import com.oheers.fish.api.fishing.CatchType;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.fishing.Processor;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.messages.ConfigMessage;
import java.time.LocalDateTime;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HuntingProcessor
extends Processor<EntityDeathEvent> {
    @Override
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void process(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof org.bukkit.entity.Fish)) {
            return;
        }
        org.bukkit.entity.Fish fishEntity = (org.bukkit.entity.Fish)livingEntity;
        if (MainConfig.getInstance().isFishHuntIgnoreSpawnerFish() && fishEntity.fromMobSpawner()) {
            return;
        }
        Player player = event.getEntity().getKiller();
        if (player == null) {
            return;
        }
        if (!this.isCustomFishAllowed(player)) {
            return;
        }
        if (MainConfig.getInstance().requireFishingPermission() && !player.hasPermission("emf.use_rod")) {
            ConfigMessage.NO_PERMISSION_FISHING.getMessage().send((Audience)player);
            return;
        }
        ItemStack fish = this.getFish(player, fishEntity.getLocation(), player.getInventory().getItemInMainHand());
        if (fish == null || fish.getType().isAir()) {
            return;
        }
        event.getDrops().clear();
        if (MainConfig.getInstance().giveStraightToInventory() && this.isSpaceForNewFish((Inventory)player.getInventory())) {
            FishUtils.giveItem(fish, player);
        } else {
            event.getDrops().add(fish);
        }
    }

    @Override
    protected boolean isEnabled() {
        return MainConfig.getInstance().isHuntEnabled();
    }

    @Override
    protected boolean competitionOnlyCheck() {
        Competition active = Competition.getCurrentlyActive();
        if (active != null) {
            return active.getCompetitionFile().isAllowHunting();
        }
        return !MainConfig.getInstance().isFishHuntOnlyInCompetition();
    }

    @Override
    protected boolean fireEvent(@NotNull Fish fish, @NotNull Player player) {
        return new EMFFishHuntEvent(fish, player, LocalDateTime.now()).callEvent();
    }

    @Override
    protected ConfigMessage getCaughtMessage() {
        return ConfigMessage.FISH_HUNTED;
    }

    @Override
    protected ConfigMessage getLengthlessCaughtMessage() {
        return ConfigMessage.FISH_LENGTHLESS_HUNTED;
    }

    @Override
    protected boolean shouldCatchBait() {
        return false;
    }

    @Override
    public boolean canUseFish(@NotNull Fish fish) {
        return fish.getCatchType() == CatchType.HUNT || fish.getCatchType() == CatchType.BOTH;
    }
}

