/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing.items.config;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.Logging;
import com.oheers.fish.api.config.ConfigBase;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RarityConversions {
    public void performCheck() {
        ConfigBase config;
        Section raritiesSection;
        File raritiesFile = new File(EvenMoreFish.getInstance().getDataFolder(), "rarities.yml");
        if (!raritiesFile.exists() || !raritiesFile.isFile()) {
            return;
        }
        EvenMoreFish.getInstance().getLogger().info("Performing automatic conversion of rarity configs.");
        File raritiesDir = this.getRaritiesDirectory();
        if (!raritiesDir.exists()) {
            raritiesDir.mkdirs();
        }
        if ((raritiesSection = (config = new ConfigBase(raritiesFile, (Plugin)EvenMoreFish.getInstance(), false)).getConfig().getSection("rarities")) == null) {
            this.finalizeConversion(config);
            return;
        }
        for (String rarityKey : raritiesSection.getRoutesAsStrings(false)) {
            Section section = raritiesSection.getSection(rarityKey);
            if (section == null) continue;
            this.convertSectionToFile(section);
        }
        this.finalizeConversion(config);
    }

    private void finalizeConversion(@NotNull ConfigBase raritiesConfig) {
        File file = raritiesConfig.getFile();
        file.renameTo(new File(EvenMoreFish.getInstance().getDataFolder(), "rarities.yml.old"));
        file.delete();
        Logging.info(ComponentMessage.componentMessage("<yellow>Your rarity configs have been automatically converted to the new format.").get());
    }

    public File getRaritiesDirectory() {
        return new File(EvenMoreFish.getInstance().getDataFolder(), "rarities");
    }

    private void convertSectionToFile(@NotNull Section section) {
        String id = section.getNameAsString();
        if (id == null) {
            return;
        }
        File file = new File(EvenMoreFish.getInstance().getDataFolder(), "rarities/" + id + ".yml");
        ConfigBase configBase = new ConfigBase(file, (Plugin)EvenMoreFish.getInstance(), false);
        YamlDocument config = configBase.getConfig();
        config.setAll(section.getRouteMappedValues(true));
        config.set("id", (Object)id);
        config.set("disabled", (Object)false);
        configBase.save();
    }
}

