/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing.rods;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.AbstractFileBasedManager;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.fishing.rods.CustomRod;
import com.oheers.fish.fishing.rods.RodConversion;
import com.oheers.fish.utils.nbt.NbtUtils;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RodManager
extends AbstractFileBasedManager<CustomRod> {
    private static final RodManager instance = new RodManager();

    private RodManager() {
        super(BaitManager.getInstance());
    }

    public static RodManager getInstance() {
        return instance;
    }

    @Override
    protected void performPreLoadConversions() {
        new RodConversion().performCheck();
    }

    @Override
    protected void loadItems() {
        this.performPreLoadConversions();
        this.loadItemsFromFiles("rods", CustomRod::new, CustomRod::getId, rod -> {
            if (rod.isDisabled()) {
                return true;
            }
            if (rod.getRecipe() != null) {
                rod.getRecipe().register();
            }
            return false;
        });
    }

    @Override
    protected void logLoadedItems() {
        EvenMoreFish.getInstance().getLogger().info("Loaded RodManager with " + this.itemMap.size() + " Custom Rods.");
    }

    @Override
    protected void clearMap(boolean reload) {
        if (reload) {
            this.itemMap.forEach((id, rod) -> {
                if (rod.getRecipe() != null) {
                    rod.getRecipe().unregister();
                }
            });
        }
        super.clearMap(reload);
    }

    @Nullable
    public CustomRod getRod(@NotNull ItemStack item) {
        String rodId = NbtUtils.getString(item, "emf-rod-id");
        if (rodId != null) {
            return (CustomRod)this.getItem(rodId);
        }
        if (NbtUtils.hasKey(item, "emf-rod-nbt")) {
            return (CustomRod)this.getItem("default");
        }
        return null;
    }
}

