/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.gui.guis;

import com.oheers.fish.Checks;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.baits.model.ApplicationResult;
import com.oheers.fish.config.GuiConfig;
import com.oheers.fish.exceptions.MaxBaitReachedException;
import com.oheers.fish.exceptions.MaxBaitsReachedException;
import com.oheers.fish.gui.ConfigGui;
import com.oheers.fish.libs.inventorygui.GuiStorageElement;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.ArrayList;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyBaitsGui
extends ConfigGui {
    private final Inventory baitInventory;

    public ApplyBaitsGui(@NotNull Player player, @Nullable Inventory baitInventory) {
        super(GuiConfig.getInstance().getConfig().getSection("apply-baits-menu"), (HumanEntity)player);
        this.baitInventory = Objects.requireNonNullElseGet(baitInventory, () -> Bukkit.createInventory((InventoryHolder)player, (int)54));
        this.setCloseAction(close -> {
            this.processBaits();
            this.doRescue();
            return false;
        });
        this.createGui();
        Section config = this.getGuiConfig();
        if (config != null) {
            this.getGui().addElement(new GuiStorageElement(FishUtils.getCharFromString(this.getGuiConfig().getString("bait-character", "b"), 'b'), this.baitInventory));
        }
    }

    private void processBaits() {
        ItemStack handItem = this.player.getInventory().getItemInMainHand();
        if (!Checks.canUseRod(handItem)) {
            return;
        }
        boolean changedRod = false;
        ArrayList<String> ignoredBaits = new ArrayList<String>();
        for (ItemStack item : this.baitInventory.getContents()) {
            ApplicationResult result;
            BaitHandler bait = BaitManager.getInstance().getBait(item);
            if (bait == null || ignoredBaits.contains(bait.getId())) continue;
            try {
                result = BaitNBTManager.applyBaitedRodNBT(handItem, bait, item.getAmount());
                EvenMoreFish.getInstance().getMetricsManager().incrementBaitsApplied(item.getAmount());
            }
            catch (MaxBaitReachedException exception) {
                EMFMessage message = ConfigMessage.BAITS_MAXED_ON_ROD.getMessage();
                message.setBait(bait.format(bait.getId()));
                message.send((Audience)this.player);
                ignoredBaits.add(bait.getId());
                continue;
            }
            catch (MaxBaitsReachedException exception) {
                ConfigMessage.BAITS_MAXED.getMessage().send((Audience)this.player);
                return;
            }
            if (result == null || result.getFishingRod() == null) continue;
            this.baitInventory.remove(item);
            handItem = result.getFishingRod();
            changedRod = true;
        }
        if (changedRod) {
            this.player.getInventory().setItemInMainHand(handItem);
        }
    }
}

