/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Batch;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.ExecutorProviderCompletionStage;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

abstract class AbstractBatch
implements Batch {
    static final Set<SQLDialect> NO_SUPPORT_BATCH = SQLDialect.supportedBy(SQLDialect.DUCKDB, SQLDialect.TRINO);
    final Configuration configuration;
    final DSLContext dsl;

    AbstractBatch(Configuration configuration) {
        this.configuration = configuration;
        this.dsl = DSL.using(configuration);
    }

    @Override
    public final CompletionStage<int[]> executeAsync() {
        return this.executeAsync(this.configuration.executorProvider().provide());
    }

    @Override
    public final CompletionStage<int[]> executeAsync(Executor executor) {
        return ExecutorProviderCompletionStage.of(CompletableFuture.supplyAsync(Tools.blocking(this::execute), executor), () -> executor);
    }
}

