/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.JSONB;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.Param;
import com.oheers.fish.libs.jooq.ParamMode;
import com.oheers.fish.libs.jooq.QualifiedRecord;
import com.oheers.fish.libs.jooq.Result;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.impl.AbstractParamX;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultBinding;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.LazyName;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SimpleQueryPart;
import com.oheers.fish.libs.jooq.tools.StringUtils;
import java.util.Arrays;
import java.util.Set;

abstract class AbstractParam<T>
extends AbstractParamX<T>
implements SimpleQueryPart {
    private static Set<SQLDialect> NO_SUPPORT_ARRAY_BINDS = SQLDialect.supportedBy(SQLDialect.TRINO);
    private static Set<SQLDialect> NO_SUPPORT_INTERVAL_BINDS = SQLDialect.supportedBy(SQLDialect.TRINO);
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_VALUE};
    private final String paramName;
    T value;
    private boolean inline;

    AbstractParam(T value, DataType<T> type) {
        this(value, type, null);
    }

    AbstractParam(T value, DataType<T> type, String paramName) {
        super(AbstractParam.name(value, paramName), type);
        this.paramName = paramName;
        this.value = value;
    }

    @Override
    final boolean isPossiblyNullable() {
        return !this.inline || this.value == null;
    }

    static final Name name(Object value, String paramName) {
        return new LazyName(() -> {
            String string;
            if (paramName != null) {
                string = paramName;
            } else if (value instanceof Result) {
                Result r = (Result)value;
                string = r.fieldsRow().toString();
            } else if (value instanceof QualifiedRecord) {
                QualifiedRecord q = (QualifiedRecord)value;
                string = q.getQualifier().getName();
            } else {
                string = AbstractParam.name(value);
            }
            return DSL.name(string);
        });
    }

    private static final String name(Object value) {
        if (value instanceof byte[]) {
            byte[] b2 = (byte[])value;
            return "b_" + Internal.hash0(Arrays.hashCode(Arrays.copyOf(b2, 16)));
        }
        if (value instanceof Object[]) {
            Object[] o = (Object[])value;
            return "a_" + Internal.hash0(Arrays.hashCode(Arrays.copyOf(o, 16)));
        }
        if (value instanceof JSONB) {
            JSONB d2 = (JSONB)value;
            return d2.data();
        }
        return String.valueOf(value);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        return this.getBinding() instanceof DefaultBinding.InternalBinding && AbstractParam.positive(this.value);
    }

    private static boolean positive(Object value) {
        Number n;
        return value instanceof Number ? (n = (Number)value).doubleValue() >= 0.0 : false;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    final void setConverted0(Object value) {
        this.value = this.getDataType().convert(value);
    }

    @Override
    public final T getValue() {
        return this.value;
    }

    @Override
    public final String getParamName() {
        return this.paramName;
    }

    @Override
    final void setInline0(boolean inline) {
        this.inline = inline;
    }

    @Override
    public final boolean isInline() {
        return this.inline;
    }

    boolean isInline(Context<?> ctx) {
        return this.isInline() || ctx.paramType() == ParamType.INLINED || ctx.paramType() == ParamType.NAMED_OR_INLINED && StringUtils.isBlank(this.paramName) || NO_SUPPORT_ARRAY_BINDS.contains((Object)ctx.dialect()) && this.getDataType().isArray() || NO_SUPPORT_INTERVAL_BINDS.contains((Object)ctx.dialect()) && this.getDataType().isInterval();
    }

    @Override
    public final ParamType getParamType() {
        return this.inline ? ParamType.INLINED : (StringUtils.isBlank(this.paramName) ? ParamType.INDEXED : ParamType.NAMED);
    }

    @Override
    public final ParamMode getParamMode() {
        return ParamMode.IN;
    }

    @Override
    public void accept(Context<?> ctx) {
    }

    @Override
    public final T $value() {
        return this.value;
    }

    @Override
    public final boolean $inline() {
        return this.inline;
    }

    @Override
    public Param<T> $value(T newValue) {
        throw new QOM.NotYetImplementedException();
    }

    @Override
    public Param<T> $inline(boolean inline) {
        throw new QOM.NotYetImplementedException();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Param) {
            Param p = (Param)that;
            Object thatValue = p.getValue();
            if (this.value == null) {
                return thatValue == null;
            }
            if (this.value instanceof byte[] && thatValue instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])thatValue);
            }
            if (this.value instanceof Object[] && thatValue instanceof Object[]) {
                return Arrays.equals((Object[])this.value, (Object[])thatValue);
            }
            return this.value.equals(thatValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n;
        if (this.value == null) {
            n = 0;
        } else {
            T t = this.value;
            if (t instanceof byte[]) {
                byte[] a2 = (byte[])t;
                n = Arrays.hashCode(a2);
            } else {
                t = this.value;
                if (t instanceof Object[]) {
                    Object[] a3 = (Object[])t;
                    n = Arrays.hashCode(a3);
                } else {
                    n = this.value.hashCode();
                }
            }
        }
        return n;
    }
}

