/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Condition;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.conf.RenderOptionalKeyword;
import com.oheers.fish.libs.jooq.impl.AbstractQueryPart;
import com.oheers.fish.libs.jooq.impl.AliasedSelect;
import com.oheers.fish.libs.jooq.impl.ArrayTable;
import com.oheers.fish.libs.jooq.impl.CommonTableExpressionImpl;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DerivedTable;
import com.oheers.fish.libs.jooq.impl.JoinTable;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.NoAutoAlias;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.SelectFieldList;
import com.oheers.fish.libs.jooq.impl.SimpleCheckQueryPart;
import com.oheers.fish.libs.jooq.impl.TableImpl;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.Values;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class Alias<Q extends QueryPart>
extends AbstractQueryPart
implements QOM.UEmpty,
SimpleCheckQueryPart {
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Clause[] CLAUSES_FIELD_REFERENCE = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private static final Clause[] CLAUSES_FIELD_ALIAS = new Clause[]{Clause.FIELD, Clause.FIELD_ALIAS};
    static final Set<SQLDialect> NO_SUPPORT_ALIASED_JOIN_TABLES = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> SUPPORT_AS_REQUIRED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1 = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MYSQL);
    static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2 = SQLDialect.supportedUntil(SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.SQLITE);
    final Q wrapped;
    final Q wrapping;
    final Name alias;
    final Name[] fieldAliases;
    final boolean wrapInParentheses;

    Alias(Q wrapped, Q wrapping, Name alias) {
        this(wrapped, wrapping, alias, null, false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases, boolean wrapInParentheses) {
        this.wrapped = wrapped;
        this.wrapping = wrapping;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.wrapInParentheses = wrapInParentheses;
    }

    final Q wrapped() {
        return this.wrapped;
    }

    final boolean hasFieldAliases() {
        return Tools.isNotEmpty(this.fieldAliases);
    }

    @Override
    public final boolean isSimple(Context<?> ctx) {
        return this.wrapped instanceof Table && !ctx.declareTables() || this.wrapped instanceof Field && !ctx.declareFields();
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareAliases() && (ctx.declareFields() || ctx.declareTables())) {
            boolean aliasedJoinTable = this.wrapped instanceof JoinTable;
            if (!aliasedJoinTable) {
                ctx.declareAliases(false);
            }
            this.acceptDeclareAliasStandard(ctx);
            if (!aliasedJoinTable) {
                ctx.declareAliases(true);
            }
        } else {
            ctx.qualify(false, c2 -> c2.visit(this.alias));
        }
    }

    private final void acceptDeclareAliasTSQL(Context<?> ctx) {
        ctx.visit(this.alias).sql(" = ");
        this.toSQLWrapped(ctx);
    }

    private final void acceptDeclareAliasStandard(Context<?> context) {
        if (this.wrapped instanceof TableImpl) {
            context.scopeMarkStart((QueryPart)this.wrapping);
        }
        SQLDialect dialect = context.dialect();
        SQLDialect family = context.family();
        boolean emulatedDerivedColumnList = false;
        if (this.hasFieldAliases() && SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1.contains((Object)dialect) && (this.wrapped instanceof TableImpl || this.wrapped instanceof CommonTableExpressionImpl)) {
            Tools.visitSubquery(context, DSL.select(DSL.asterisk()).from((TableLike<?>)((Object)NoAutoAlias.noAutoAlias((Table)this.wrapped).as(this.alias))), 1);
        } else if (this.hasFieldAliases() && (emulatedDerivedColumnList || SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2.contains((Object)dialect))) {
            emulatedDerivedColumnList = true;
            if (this.wrapped instanceof Values && Values.NO_SUPPORT_VALUES.contains((Object)dialect)) {
                context.data(Tools.SimpleDataKey.DATA_SELECT_ALIASES, this.fieldAliases, t -> this.toSQLWrapped((Context<?>)t));
            } else {
                Select select;
                Q q = this.wrapped;
                if (q instanceof Select) {
                    Select s;
                    select = s = (Select)q;
                } else {
                    q = this.wrapped;
                    if (q instanceof DerivedTable) {
                        DerivedTable d2 = (DerivedTable)q;
                        select = d2.query();
                    } else {
                        select = DSL.select(DSL.asterisk()).from((TableLike<?>)((Object)NoAutoAlias.noAutoAlias((Table)this.wrapped).as(this.alias)));
                    }
                }
                Select wrappedAsSelect = select;
                List<Field<?>> select2 = wrappedAsSelect.getSelect();
                if (emulatedDerivedColumnList) {
                    if (AliasedSelect.avoidAliasPushdown(context, wrappedAsSelect) || !(this.wrapped instanceof Select) && !(this.wrapped instanceof DerivedTable)) {
                        SelectFieldList fields = new SelectFieldList();
                        for (int i = 0; i < this.fieldAliases.length; ++i) {
                            switch (family) {
                                default: 
                            }
                            fields.add(DSL.field("null").as(this.fieldAliases[i]));
                        }
                        Tools.visitSubquery(context, DSL.select(fields).where((Condition)DSL.falseCondition()).unionAll(wrappedAsSelect), 1);
                    } else {
                        context.sql('(').visit(new AliasedSelect(wrappedAsSelect, true, false, false, this.fieldAliases)).sql(')');
                    }
                }
            }
        } else {
            this.toSQLWrapped(context);
        }
        this.toSQLAs(context);
        context.sql(' ').qualify(false, c2 -> c2.visit(this.alias));
        if (this.hasFieldAliases() && !emulatedDerivedColumnList) {
            this.toSQLDerivedColumnList(context);
        } else {
            switch (family) {
                case HSQLDB: 
                case POSTGRES: 
                case YUGABYTEDB: {
                    Q o = this.wrapped;
                    if (!context.declareTables() || !(o instanceof ArrayTable)) break;
                    context.sql('(').visit(QueryPartListView.wrap((QueryPart[])((ArrayTable)o).fields()).qualify(false)).sql(')');
                    break;
                }
            }
        }
        if (this.wrapped instanceof TableImpl) {
            context.scopeMarkEnd((QueryPart)this.wrapping);
        }
    }

    final void toSQLAs(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_AS_REQUIRED))) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (this.wrapped instanceof Field) {
            if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
                ctx.sql(' ').visit(Keywords.K_AS);
            } else if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.ON) {
                ctx.sql(' ').visit(Keywords.K_AS);
            }
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.ON) {
            ctx.sql(' ').visit(Keywords.K_AS);
        }
    }

    private final void toSQLWrapped(Context<?> ctx) {
        if (this.wrapInParentheses) {
            ctx.data(Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES, false, c2 -> this.toSQLWrapped((Context<?>)c2, this.wrapInParentheses));
        } else {
            this.toSQLWrapped(ctx, this.wrapInParentheses);
        }
    }

    private final void toSQLWrapped(Context<?> ctx, boolean wrap) {
        boolean nestedJoinTable = this.wrapped instanceof JoinTable;
        if (wrap) {
            if (nestedJoinTable) {
                ctx.sqlIndentStart('(');
            } else {
                ctx.sql('(');
            }
        }
        if (nestedJoinTable && NO_SUPPORT_ALIASED_JOIN_TABLES.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped)));
        } else {
            ctx.visit((QueryPart)this.wrapped);
        }
        if (wrap) {
            if (nestedJoinTable) {
                ctx.sqlIndentEnd(')');
            } else {
                ctx.sql(')');
            }
        }
    }

    private final void toSQLDerivedColumnList(Context<?> ctx) {
        ctx.sql(" (").visit(QueryPartListView.wrap((QueryPart[])this.fieldAliases)).sql(')');
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        if (ctx.declareFields() || ctx.declareTables()) {
            if (this.wrapped instanceof Table) {
                return CLAUSES_TABLE_ALIAS;
            }
            return CLAUSES_FIELD_ALIAS;
        }
        if (this.wrapped instanceof Table) {
            return CLAUSES_TABLE_REFERENCE;
        }
        return CLAUSES_FIELD_REFERENCE;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.alias.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Alias) {
            Alias o = (Alias)that;
            return Objects.equals(this.alias, o.alias) && Arrays.equals(this.fieldAliases, o.fieldAliases);
        }
        return super.equals(that);
    }
}

