/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.RenderContext;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.Cast;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Collection;
import java.util.Set;

final class Array<T>
extends AbstractField<T[]>
implements QOM.Array<T> {
    private static final Set<SQLDialect> REQUIRES_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final FieldsImpl<Record> fields;

    Array(Collection<? extends Field<T>> fields) {
        super(Names.N_ARRAY, Array.type(fields));
        this.fields = new FieldsImpl(fields);
    }

    @Override
    public boolean generatesCast() {
        return true;
    }

    private static <T> DataType<T[]> type(Collection<? extends Field<T>> fields) {
        if (fields == null || fields.isEmpty()) {
            return SQLDataType.OTHER.getArrayDataType();
        }
        return fields.iterator().next().getDataType().getArrayDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        Cast.renderCastIf(ctx, c2 -> {
            switch (ctx.family()) {
                default: 
            }
            ctx.visit(Keywords.K_ARRAY).sql('[').visit(this.fields).sql(']');
        }, c2 -> {
            DataType type = (DataType)c2.data(Tools.ExtendedDataKey.DATA_EMPTY_ARRAY_BASE_TYPE);
            if (type != null && !type.isOther()) {
                c2.sql(type.getCastTypeName(ctx.configuration())).sql("[]");
            } else {
                c2.visit(Keywords.K_INT).sql("[]");
            }
        }, () -> this.fields.fields.length == 0 && REQUIRES_CAST.contains((Object)ctx.dialect()) && ctx.castMode() != RenderContext.CastMode.NEVER);
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<T>> $elements() {
        return QOM.unmodifiable((QueryPart[])this.fields.fields);
    }
}

