/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Comment;
import com.oheers.fish.libs.jooq.CommentOnFinalStep;
import com.oheers.fish.libs.jooq.CommentOnIsStep;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function5;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import java.util.Set;

final class CommentOnImpl
extends AbstractDDLQuery
implements QOM.CommentOn,
CommentOnIsStep,
CommentOnFinalStep {
    final Table<?> table;
    final boolean isView;
    final boolean isMaterializedView;
    final Field<?> field;
    Comment comment;
    private static final Set<SQLDialect> SUPPORTS_COMMENT_ON_VIEW = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORTS_COMMENT_ON_MATERIALIZED_VIEW = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, boolean isMaterializedView, Field<?> field) {
        this(configuration, table, isView, isMaterializedView, field, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, boolean isMaterializedView) {
        this(configuration, table, isView, isMaterializedView, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, boolean isMaterializedView, Field<?> field, Comment comment) {
        super(configuration);
        this.table = table;
        this.isView = isView;
        this.isMaterializedView = isMaterializedView;
        this.field = field;
        this.comment = comment;
    }

    @Override
    public final CommentOnImpl is(String comment) {
        return this.is(DSL.comment(comment));
    }

    @Override
    public final CommentOnImpl is(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.table != null) {
                    this.acceptMySQL(ctx);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptMySQL(Context<?> ctx) {
        ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_COMMENT).sql(" = ").visit(this.comment);
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_ON).sql(' ');
        if (this.table != null) {
            if (this.isView && SUPPORTS_COMMENT_ON_VIEW.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_VIEW).sql(' ');
            } else if (this.isMaterializedView && SUPPORTS_COMMENT_ON_MATERIALIZED_VIEW.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_MATERIALIZED).sql(' ').visit(Keywords.K_VIEW).sql(' ');
            } else {
                ctx.visit(Keywords.K_TABLE).sql(' ');
            }
            ctx.visit(this.table);
        } else if (this.field != null) {
            ctx.visit(Keywords.K_COLUMN).sql(' ').visit(this.field);
        } else {
            throw new IllegalStateException();
        }
        ctx.sql(' ').visit(Keywords.K_IS).sql(' ').visit(this.comment);
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }

    @Override
    public final boolean $isView() {
        return this.isView;
    }

    @Override
    public final boolean $isMaterializedView() {
        return this.isMaterializedView;
    }

    @Override
    public final Field<?> $field() {
        return this.field;
    }

    @Override
    public final Comment $comment() {
        return this.comment;
    }

    @Override
    public final QOM.CommentOn $table(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$isView(), this.$isMaterializedView(), this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $isView(boolean newValue) {
        return this.$constructor().apply(this.$table(), newValue, this.$isMaterializedView(), this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $isMaterializedView(boolean newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), newValue, this.$field(), this.$comment());
    }

    @Override
    public final QOM.CommentOn $field(Field<?> newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), this.$isMaterializedView(), newValue, this.$comment());
    }

    @Override
    public final QOM.CommentOn $comment(Comment newValue) {
        return this.$constructor().apply(this.$table(), this.$isView(), this.$isMaterializedView(), this.$field(), newValue);
    }

    public final Function5<? super Table<?>, ? super Boolean, ? super Boolean, ? super Field<?>, ? super Comment, ? extends QOM.CommentOn> $constructor() {
        return (a1, a2, a3, a4, a5) -> new CommentOnImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (boolean)a3, (Field<?>)a4, (Comment)a5);
    }
}

