/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Expression;
import com.oheers.fish.libs.jooq.impl.ExpressionOperator;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;

final class Concat
extends AbstractField<String>
implements QOM.Concat {
    private final Field<?>[] arguments;

    Concat(Field<?> ... arguments) {
        super(Names.N_CONCAT, SQLDataType.VARCHAR);
        this.arguments = arguments;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.arguments.length == 0) {
            ctx.visit(DSL.inline(null, this.getDataType()));
            return;
        }
        if (this.arguments.length == 1) {
            ctx.visit(this.arguments[0]);
            return;
        }
        Field<String>[] cast = Tools.castAllIfNeeded(this.arguments, String.class);
        if (!Boolean.TRUE.equals(ctx.settings().isRenderCoalesceToEmptyStringInConcat()) || ctx.configuration().commercial(() -> "Auto-coalescing of CONCAT arguments is available in the jOOQ 3.15 Professional Edition and jOOQ Enterprise Edition, see https://github.com/jOOQ/jOOQ/issues/11757")) {
            // empty if block
        }
        ExpressionOperator op = ExpressionOperator.CONCAT;
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.function(DSL.systemName("concat"), SQLDataType.VARCHAR, cast));
                return;
            }
        }
        Expression<String> expression = new Expression<String>(op, false, cast[0], cast[1]);
        for (int i = 2; i < cast.length; ++i) {
            expression = new Expression<String>(op, false, expression, cast[i]);
        }
        ctx.visit(expression);
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $arg1() {
        return QOM.unmodifiable((QueryPart[])this.arguments);
    }

    @Override
    public final Function1<? super QOM.UnmodifiableList<? extends Field<?>>, ? extends QOM.Concat> $constructor() {
        return l -> new Concat(l.toArray(Tools.EMPTY_FIELD));
    }
}

