/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DMLQuery;
import com.oheers.fish.libs.jooq.Delete;
import com.oheers.fish.libs.jooq.Insert;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.SelectFieldOrAsterisk;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableOptions;
import com.oheers.fish.libs.jooq.Update;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.AbstractTable;
import com.oheers.fish.libs.jooq.impl.AutoAlias;
import com.oheers.fish.libs.jooq.impl.CustomQueryPart;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.MergeImpl;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SelectFieldList;
import com.oheers.fish.libs.jooq.impl.TableAlias;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.TopLevelCte;
import java.util.Set;

final class DataChangeDeltaTable<R extends Record>
extends AbstractTable<R>
implements AutoAlias<Table<R>>,
QOM.DataChangeDeltaTable<R> {
    private final Set<SQLDialect> EMULATE_USING_CTE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final QOM.ResultOption resultOption;
    private final DMLQuery<R> query;
    private final Table<R> table;
    private final Name alias;

    DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query) {
        this(resultOption, query, DataChangeDeltaTable.table(query));
    }

    private DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query, Table<R> table) {
        this(resultOption, query, table, table.getUnqualifiedName());
    }

    private DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query, Table<R> table, Name alias) {
        super(TableOptions.expression(), alias);
        this.resultOption = resultOption;
        this.query = query;
        this.table = table;
        this.alias = alias;
    }

    private static final <R extends Record> Table<R> table(DMLQuery<R> query) {
        if (query instanceof Insert || query instanceof Update || query instanceof Delete) {
            return Tools.abstractDMLQuery(query).table();
        }
        if (query instanceof MergeImpl) {
            MergeImpl m = (MergeImpl)query;
            return m.table();
        }
        throw new IllegalStateException("Unsupported query type: " + String.valueOf(query));
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.EMULATE_USING_CTE.contains((Object)ctx.dialect())) {
            this.acceptCte(ctx);
        } else {
            this.acceptNative(ctx);
        }
    }

    private final void acceptCte(Context<?> ctx) {
        TopLevelCte cte = (TopLevelCte)ctx.data(Tools.SimpleDataKey.DATA_TOP_LEVEL_CTE);
        if (cte != null) {
            cte.add(DSL.name(this.alias).as(DSL.resultQuery("{0}", CustomQueryPart.of(c2 -> c2.visit(this.query).formatSeparator().visit(Keywords.K_RETURNING).sql(' ').visit(new SelectFieldList((SelectFieldOrAsterisk[])this.table.fields()))))));
        }
        ctx.visit(DSL.table(this.alias));
    }

    private final void acceptNative(Context<?> ctx) {
        switch (this.resultOption) {
            case FINAL: {
                ctx.visit(Keywords.K_FINAL);
                break;
            }
            case OLD: {
                ctx.visit(Keywords.K_OLD);
                break;
            }
            case NEW: {
                ctx.visit(Keywords.K_NEW);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported result option: " + String.valueOf((Object)this.resultOption));
            }
        }
        ctx.sql(' ').visit(Keywords.K_TABLE).sqlIndentStart(" (");
        Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE, () -> ctx.visit(this.query).sqlIndentEnd(')'));
    }

    @Override
    public Table<R> as(Name as) {
        return new TableAlias<R>(new DataChangeDeltaTable<R>(this.resultOption, this.query, this.table, as), as);
    }

    @Override
    public Table<R> as(Name as, Name ... fieldAliases) {
        return new TableAlias<R>(new DataChangeDeltaTable<R>(this.resultOption, this.query, this.table, as), as, fieldAliases);
    }

    @Override
    public final Table<R> autoAlias(Context<?> ctx, Table<R> t) {
        return t.as(this.alias);
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.table.getRecordType();
    }

    @Override
    final FieldsImpl<R> fields0() {
        return ((AbstractRow)this.table.as((Name)this.alias).fieldsRow()).fields;
    }

    @Override
    public final QOM.ResultOption $resultOption() {
        return this.resultOption;
    }

    @Override
    public final DMLQuery<R> $query() {
        return this.query;
    }
}

