/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.impl.AbstractParseContext;
import com.oheers.fish.libs.jooq.impl.JSONContentHandler;

final class JSONParser
extends AbstractParseContext {
    final JSONContentHandler handler;

    JSONParser(DSLContext dsl, String chars, JSONContentHandler handler) {
        super(dsl, chars);
        this.handler = handler;
        this.parseWhitespaceIf();
    }

    final void parse() {
        this.parseValue();
        if (!this.done()) {
            throw this.exception("Unexpected content");
        }
    }

    private final void parseValue() {
        if (!this.parseValueIf()) {
            throw this.expected("Value");
        }
    }

    private final boolean parseValueIf() {
        switch (this.character()) {
            case '{': {
                this.parseObject();
                return true;
            }
            case '[': {
                this.parseArray();
                return true;
            }
            case 'n': {
                this.parseNull();
                return true;
            }
            case 't': {
                this.parseTrue();
                return true;
            }
            case 'f': {
                this.parseFalse();
                return true;
            }
            case '\"': {
                this.parseString();
                return true;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.parseNumber();
                return true;
            }
        }
        return false;
    }

    private final void parseNumber() {
        this.handler.valueNumber(this.parseNumberLiteral());
    }

    private final String parseNumberLiteral() {
        int i;
        int p = this.position();
        block3: for (i = this.position(); i < this.chars.length; ++i) {
            switch (this.character(i)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    continue block3;
                }
            }
        }
        this.position(i);
        this.parseWhitespaceIf();
        return new String(this.chars, p, i - p);
    }

    private final void parseString() {
        this.handler.valueString(this.parseStringLiteral());
    }

    private final String parseStringLiteral() {
        int p0;
        this.parse('\"', false);
        StringBuilder sb = null;
        int p1 = p0 = this.position();
        block12: for (int i = p0; i < this.chars.length; ++i) {
            char c1 = this.character(i);
            switch (c1) {
                case '\\': {
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append(this.chars, p0, i - p0);
                    } else {
                        sb.append(this.chars, p1, i - p1);
                    }
                    char c2 = this.character(++i);
                    switch (c2) {
                        case 'b': {
                            c1 = '\b';
                            break;
                        }
                        case 'n': {
                            c1 = '\n';
                            break;
                        }
                        case 't': {
                            c1 = '\t';
                            break;
                        }
                        case 'r': {
                            c1 = '\r';
                            break;
                        }
                        case 'f': {
                            c1 = '\f';
                            break;
                        }
                        case 'u': {
                            c1 = (char)this.parseInt(this.substring(i + 1, i + 5), 16);
                            i += 4;
                            break;
                        }
                        default: {
                            c1 = c2;
                        }
                    }
                    p1 = i + 1;
                    sb.append(c1);
                    continue block12;
                }
                case '\"': {
                    this.position(i + 1);
                    this.parseWhitespaceIf();
                    if (sb != null) {
                        sb.append(this.chars, p1, i - p1);
                        return sb.toString();
                    }
                    return new String(this.chars, p0, i - p0);
                }
            }
        }
        throw this.exception("String literal not terminated");
    }

    private final void parseFalse() {
        this.parse("false");
        this.handler.valueFalse();
    }

    private final void parseTrue() {
        this.parse("true");
        this.handler.valueTrue();
    }

    private final void parseNull() {
        this.parse("null");
        this.handler.valueNull();
    }

    private final void parseObject() {
        this.parse('{');
        this.handler.startObject();
        if (!this.parseIf('}')) {
            do {
                this.handler.property(this.parseStringLiteral());
                this.parse(':');
                this.parseValue();
            } while (this.parseIf(','));
            this.parse('}');
        }
        this.handler.endObject();
    }

    private final void parseArray() {
        this.parse('[');
        this.handler.startArray();
        while (this.parseValueIf() && this.parseIf(',')) {
        }
        this.parse(']');
        this.handler.endArray();
    }

    @Override
    final int afterWhitespace(int p) {
        block3: for (int i = p; i < this.chars.length; ++i) {
            switch (this.chars[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    p = i + 1;
                    continue block3;
                }
                default: {
                    p = i;
                    break block3;
                }
            }
        }
        return p;
    }

    public String toString() {
        return this.mark();
    }
}

