/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

final class LazyCopyMap<K, V>
extends AbstractMap<K, V> {
    final Map<K, V> copy = new HashMap();
    final Map<K, V> delegate;

    LazyCopyMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        V value = this.copy.get(key);
        if (value == null && (value = this.delegate.get(key)) != null) {
            this.copy.put(key, value);
        }
        return value;
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.copy.put(key, value);
        return this.delegate.put(key, value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.get(key);
        this.copy.putIfAbsent(key, value);
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        this.copy.replace(key, oldValue, newValue);
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.copy.replace(key, value);
        return this.delegate.replace(key, value);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.copy.replaceAll(function);
        this.delegate.replaceAll(function);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.get(key);
        this.copy.computeIfAbsent((K)key, mappingFunction);
        return this.delegate.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.get(key);
        this.copy.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        return this.delegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.get(key);
        this.copy.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        return this.delegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.get(key);
        this.copy.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.copy.isEmpty() && this.delegate.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.copy.containsValue(value) || this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.copy.containsKey(key) || this.delegate.containsKey(key);
    }

    @Override
    public V remove(Object key) {
        this.copy.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.copy.remove(key, value);
        return this.delegate.remove(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.copy.putAll(m);
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.copy.clear();
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

