/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.math.BigDecimal;
import java.util.Objects;

final class Log10
extends AbstractField<BigDecimal>
implements QOM.Log10 {
    final Field<? extends Number> value;

    Log10(Field<? extends Number> value) {
        super(Names.N_LOG10, Tools.allNotNull(SQLDataType.NUMERIC, value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case YUGABYTEDB: {
                return false;
            }
            case DUCKDB: 
            case POSTGRES: 
            case SQLITE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case YUGABYTEDB: {
                ctx.visit(DSL.log(this.value, DSL.inline(10)));
                break;
            }
            case DUCKDB: 
            case POSTGRES: 
            case SQLITE: {
                ctx.visit(Names.N_LOG10).sql('(').visit(this.value).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_LOG10, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.value;
    }

    @Override
    public final QOM.Log10 $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.Log10> $constructor() {
        return a1 -> new Log10((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Log10) {
            QOM.Log10 o = (QOM.Log10)that;
            return Objects.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

