/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.math.BigDecimal;
import java.util.Objects;

final class Power
extends AbstractField<BigDecimal>
implements QOM.Power {
    final Field<? extends Number> base;
    final Field<? extends Number> exponent;

    Power(Field<? extends Number> base, Field<? extends Number> exponent) {
        super(Names.N_POWER, Tools.allNotNull(SQLDataType.NUMERIC, base, exponent));
        this.base = Tools.nullSafeNotNull(base, SQLDataType.INTEGER);
        this.exponent = Tools.nullSafeNotNull(exponent, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(DSL.exp(Internal.imul(DSL.ln(this.base), this.exponent)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_POWER, this.getDataType(), this.base, this.exponent));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.base;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.exponent;
    }

    @Override
    public final QOM.Power $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue, (Field<? extends Number>)this.$arg2());
    }

    @Override
    public final QOM.Power $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)this.$arg1(), (Field<? extends Number>)newValue);
    }

    @Override
    public final Function2<? super Field<? extends Number>, ? super Field<? extends Number>, ? extends QOM.Power> $constructor() {
        return (a1, a2) -> new Power((Field<? extends Number>)a1, (Field<? extends Number>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Power) {
            QOM.Power o = (QOM.Power)that;
            return Objects.equals(this.$base(), o.$base()) && Objects.equals(this.$exponent(), o.$exponent());
        }
        return super.equals(that);
    }
}

