/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.BindContext;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.QualifiedRecord;
import com.oheers.fish.libs.jooq.RecordQualifier;
import com.oheers.fish.libs.jooq.RenderContext;
import com.oheers.fish.libs.jooq.Scope;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.exception.SQLDialectNotSupportedException;
import com.oheers.fish.libs.jooq.impl.AbstractParam;
import com.oheers.fish.libs.jooq.impl.Cast;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultBinding;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;

final class QualifiedRecordConstant<R extends QualifiedRecord<R>>
extends AbstractParam<R>
implements QOM.UNotYetImplemented {
    final RecordQualifier<R> qualifier;

    QualifiedRecordConstant(R value, RecordQualifier<R> qualifier) {
        super(value, qualifier.getDataType());
        this.qualifier = qualifier;
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext ctx) {
        ParamType paramType = ctx.paramType();
        if (this.isInline()) {
            ctx.paramType(ParamType.INLINED);
        }
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.toSQLInline(ctx);
                break;
            }
            default: {
                this.toSQLInline(ctx);
            }
        }
        if (this.isInline()) {
            ctx.paramType(paramType);
        }
    }

    @Override
    final boolean isInline(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        return this.value == null || super.isInline(ctx);
    }

    private final void toSQLInline(RenderContext ctx) {
        Cast.renderCastIf(ctx, c2 -> {
            if (this.value == null) {
                c2.visit(Keywords.K_NULL);
            } else {
                switch (c2.family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        c2.visit(Keywords.K_ROW);
                        break;
                    }
                    default: {
                        c2.visit(this.mappedQualifier(ctx));
                    }
                }
                c2.sql('(');
                String separator = "";
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    c2.sql(separator);
                    c2.visit(DSL.val(((QualifiedRecord)this.value).get(field), field));
                    separator = ", ";
                }
                c2.sql(')');
            }
        }, c2 -> c2.visit(this.mappedQualifier(ctx)), () -> DefaultBinding.DefaultRecordBinding.REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()));
    }

    private final RecordQualifier<?> mappedQualifier(RenderContext ctx) {
        RecordQualifier<?> mapped = Tools.getMappedQualifier(ctx, this.qualifier);
        return mapped != null ? mapped : this.qualifier;
    }

    @Deprecated
    private final String getInlineConstructor(RenderContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return "ROW";
            }
        }
        return Tools.getMappedUDTName((Scope)ctx, (QualifiedRecord)this.value);
    }

    final void bind0(BindContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.value == null) break;
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    ctx.visit(DSL.val(((QualifiedRecord)this.value).get(field), field.getDataType()));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + String.valueOf((Object)ctx.dialect()));
            }
        }
    }
}

