/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.ExecuteType;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.RecordContext;
import com.oheers.fish.libs.jooq.RecordListener;
import com.oheers.fish.libs.jooq.conf.InvocationOrder;
import com.oheers.fish.libs.jooq.exception.ControlFlowSignal;
import com.oheers.fish.libs.jooq.impl.AbstractRecord;
import com.oheers.fish.libs.jooq.impl.AbstractScope;
import com.oheers.fish.libs.jooq.impl.DefaultRecordContext;
import com.oheers.fish.libs.jooq.impl.ThrowingFunction;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Arrays;
import java.util.function.Supplier;

final class RecordDelegate<R extends Record> {
    private final Configuration configuration;
    private final Supplier<R> recordSupplier;
    private final Boolean fetched;
    private final RecordLifecycleType type;

    RecordDelegate(Configuration configuration, Supplier<R> recordSupplier, Boolean fetched) {
        this(configuration, recordSupplier, fetched, RecordLifecycleType.LOAD);
    }

    RecordDelegate(Configuration configuration, Supplier<R> recordSupplier, Boolean fetched, RecordLifecycleType type) {
        this.configuration = configuration;
        this.recordSupplier = recordSupplier;
        this.fetched = fetched;
        this.type = type;
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record, RecordLifecycleType type) {
        return new RecordDelegate<Record>(configuration, () -> record, null, type);
    }

    final <E extends Exception> R operate(ThrowingFunction<R, R, E> operation) throws E {
        Exception exception;
        AbstractScope ctx;
        RecordListener[] listeners;
        Record record;
        block31: {
            record = (Record)this.recordSupplier.get();
            if (this.fetched != null && record instanceof AbstractRecord) {
                ((AbstractRecord)record).fetched = this.fetched;
            }
            Object[] providers = null;
            listeners = null;
            ctx = null;
            exception = null;
            if (this.configuration != null && !Tools.isEmpty(providers = this.configuration.recordListenerProviders())) {
                listeners = Tools.map(providers, p -> p.provide(), RecordListener[]::new);
                ctx = new DefaultRecordContext(this.configuration, this.executeType(), record);
            }
            if (listeners != null) {
                block20: for (RecordListener recordListener : ctx == null || ctx.settings().getRecordListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                    switch (this.type.ordinal()) {
                        case 0: {
                            recordListener.loadStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case 1: {
                            recordListener.refreshStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case 2: {
                            recordListener.storeStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case 3: {
                            recordListener.insertStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case 4: {
                            recordListener.updateStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case 5: {
                            recordListener.mergeStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case 6: {
                            recordListener.deleteStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                    }
                    throw new IllegalStateException("Type not supported: " + String.valueOf((Object)this.type));
                }
            }
            if (Tools.attachRecords(this.configuration)) {
                record.attach(this.configuration);
            }
            if (operation != null) {
                try {
                    operation.apply(record);
                }
                catch (Exception e) {
                    exception = e;
                    if (e instanceof ControlFlowSignal) break block31;
                    if (ctx != null) {
                        ((DefaultRecordContext)ctx).exception = e;
                    }
                    if (listeners == null) break block31;
                    for (RecordListener listener : listeners) {
                        listener.exception((RecordContext)((Object)ctx));
                    }
                }
            }
        }
        if (listeners != null) {
            block22: for (RecordListener recordListener : ctx == null || ctx.settings().getRecordListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                switch (this.type.ordinal()) {
                    case 0: {
                        recordListener.loadEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case 1: {
                        recordListener.refreshEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case 2: {
                        recordListener.storeEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case 3: {
                        recordListener.insertEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case 4: {
                        recordListener.updateEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case 5: {
                        recordListener.mergeEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case 6: {
                        recordListener.deleteEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                }
                throw new IllegalStateException("Type not supported: " + String.valueOf((Object)this.type));
            }
        }
        if (exception != null) {
            throw exception;
        }
        return (R)record;
    }

    private final ExecuteType executeType() {
        return this.type == RecordLifecycleType.LOAD || this.type == RecordLifecycleType.REFRESH ? ExecuteType.READ : ExecuteType.WRITE;
    }

    static enum RecordLifecycleType {
        LOAD,
        REFRESH,
        STORE,
        INSERT,
        UPDATE,
        MERGE,
        DELETE;

    }
}

