/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Comparator;
import com.oheers.fish.libs.jooq.Condition;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Row;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.AbstractInList;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class RowInCondition
extends AbstractCondition
implements QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private static final Set<SQLDialect> EMULATE_IN = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.SQLITE);
    private final Row left;
    private final QueryPartList<Row> right;
    private final boolean not;

    RowInCondition(Row left, QueryPartList<? extends Row> right, boolean not) {
        this.left = left;
        this.right = new QueryPartList<Row>((Iterable<? extends Row>)right);
        this.not = not;
        this.right.replaceAll(r -> ((AbstractRow)r).convertTo(left));
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_IN.contains((Object)ctx.dialect())) {
            Condition result = DSL.or(Tools.map(this.right, r -> AbstractRow.compare(this.left, Comparator.EQUALS, r)));
            if (this.not) {
                result = result.not();
            }
            ctx.visit(result);
        } else if (this.right.size() == 0) {
            if (this.not) {
                ctx.visit(DSL.trueCondition());
            } else {
                ctx.visit(DSL.falseCondition());
            }
        } else {
            ctx.visit(this.left).sql(' ').visit((this.not ? Comparator.NOT_IN : Comparator.IN).toKeyword()).sql(" (").visit(new QueryPartListView<Row>(AbstractInList.padded(ctx, this.right, Integer.MAX_VALUE))).sql(')');
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

