/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Comparator;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Row;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.RowCondition;
import com.oheers.fish.libs.jooq.impl.RowSubqueryCondition;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class RowIsDistinctFrom
extends AbstractCondition
implements QOM.UNotYetImplemented {
    private static final Set<SQLDialect> EMULATE_DISTINCT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY);
    private static final Set<SQLDialect> EMULATE_DISTINCT_SELECT = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Row lhs;
    private final Row rhsRow;
    private final Select<?> rhsSelect;
    private final boolean not;

    RowIsDistinctFrom(Row lhs, Row rhs, boolean not) {
        this.lhs = ((AbstractRow)lhs).convertTo(rhs);
        this.rhsRow = ((AbstractRow)rhs).convertTo(lhs);
        this.rhsSelect = null;
        this.not = not;
    }

    RowIsDistinctFrom(Row lhs, Select<?> rhs, boolean not) {
        this.lhs = lhs;
        this.rhsRow = null;
        this.rhsSelect = rhs;
        this.not = not;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_DISTINCT.contains((Object)ctx.dialect()) || this.rhsSelect != null && EMULATE_DISTINCT_SELECT.contains((Object)ctx.dialect())) {
            Select intersect = DSL.select(this.lhs.fields()).intersect(this.rhsSelect != null ? this.rhsSelect : DSL.select(this.rhsRow.fields()));
            ctx.visit(this.not ? DSL.exists(intersect) : DSL.notExists(intersect));
        } else if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)ctx.dialect())) {
            if (!this.not) {
                ctx.visit(Keywords.K_NOT).sql('(');
            }
            ctx.visit(this.lhs).sql(" <=> ");
            if (this.rhsRow != null) {
                ctx.visit(this.rhsRow);
            } else {
                Tools.visitSubquery(ctx, this.rhsSelect, 256);
            }
            if (!this.not) {
                ctx.sql(')');
            }
        } else if (SQLDialect.SQLITE == ctx.family()) {
            ctx.visit(this.lhs).sql(' ').visit(Keywords.K_IS).sql(' ');
            if (!this.not) {
                ctx.visit(Keywords.K_NOT).sql(' ');
            }
            if (this.rhsRow != null) {
                ctx.visit(this.rhsRow);
            } else {
                Tools.visitSubquery(ctx, this.rhsSelect, 256);
            }
        } else {
            ctx.visit(this.rhsRow != null ? new RowCondition(this.lhs, this.rhsRow, this.not ? Comparator.IS_NOT_DISTINCT_FROM : Comparator.IS_DISTINCT_FROM) : new RowSubqueryCondition(this.lhs, this.rhsSelect, this.not ? Comparator.IS_NOT_DISTINCT_FROM : Comparator.IS_DISTINCT_FROM));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

