/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class StartsWith<T>
extends AbstractCondition
implements QOM.StartsWith<T> {
    final Field<T> string;
    final Field<T> prefix;

    StartsWith(Field<T> string, Field<T> prefix) {
        this.string = Tools.nullableIf(false, Tools.nullSafe(string, prefix.getDataType()));
        this.prefix = Tools.nullableIf(false, Tools.nullSafe(prefix, string.getDataType()));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                return false;
            }
            case DUCKDB: 
            case TRINO: {
                return true;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                ctx.visit(this.string.like(DSL.concat(Tools.escapeForLike(this.prefix, ctx.configuration()), DSL.inline("%")), '!'));
                break;
            }
            case DUCKDB: 
            case TRINO: {
                ctx.visit(DSL.function(Names.N_STARTS_WITH, SQLDataType.BOOLEAN, this.string, this.prefix));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_STARTS_WITH, SQLDataType.BOOLEAN, this.string, this.prefix));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.string;
    }

    @Override
    public final Field<T> $arg2() {
        return this.prefix;
    }

    @Override
    public final QOM.StartsWith<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.StartsWith<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.StartsWith<T>> $constructor() {
        return (a1, a2) -> new StartsWith(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.StartsWith) {
            QOM.StartsWith o = (QOM.StartsWith)that;
            return Objects.equals(this.$string(), o.$string()) && Objects.equals(this.$prefix(), o.$prefix());
        }
        return super.equals(that);
    }
}

