/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.conf.Transformation;
import com.oheers.fish.libs.jooq.impl.SelectQueryImpl;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.StringUtils;
import java.util.Set;
import java.util.function.Predicate;

final class Transformations {
    static final Set<SQLDialect> NO_SUPPORT_IN_LIMIT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    static final Set<SQLDialect> SUPPORT_MISSING_TABLE_REFERENCES = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> EMULATE_QUALIFY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_ROWNUM = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_GROUP_BY_COLUMN_INDEX = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE);
    static final Set<SQLDialect> NO_SUPPORT_CTE = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY);

    Transformations() {
    }

    static final SelectQueryImpl<?> subqueryWithLimit(QueryPart source) {
        SelectQueryImpl s = Tools.selectQueryImpl(source);
        return s != null && s.getLimit().isApplicable() ? s : null;
    }

    static final boolean transformInConditionSubqueryWithLimitToDerivedTable(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformInConditionSubqueryWithLimitToDerivedTable", configuration.settings().getTransformInConditionSubqueryWithLimitToDerivedTable(), c2 -> NO_SUPPORT_IN_LIMIT.contains((Object)c2.dialect()));
    }

    static final boolean transformInlineCTE(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformInlineCTE", configuration.settings().getTransformInlineCTE(), c2 -> NO_SUPPORT_CTE.contains((Object)c2.dialect()));
    }

    static final boolean transformQualify(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformQualify", configuration.settings().getTransformQualify(), c2 -> EMULATE_QUALIFY.contains((Object)c2.dialect()));
    }

    static final boolean transformRownum(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformRownum", configuration.settings().getTransformRownum(), c2 -> EMULATE_ROWNUM.contains((Object)c2.dialect()));
    }

    static final boolean transformAppendMissingTableReferences(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformAppendMissingTableReferences", configuration.settings().getParseAppendMissingTableReferences(), c2 -> SUPPORT_MISSING_TABLE_REFERENCES.contains((Object)c2.settings().getParseDialect()));
    }

    static final boolean transformGroupByColumnIndex(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformGroupByColumnIndex", configuration.settings().getTransformGroupByColumnIndex(), c2 -> EMULATE_GROUP_BY_COLUMN_INDEX.contains((Object)c2.dialect()));
    }

    static final boolean transform(Configuration configuration, String label, Transformation transformation, Predicate<? super Configuration> whenNeeded) {
        return (switch (StringUtils.defaultIfNull(transformation, Transformation.WHEN_NEEDED)) {
            case Transformation.NEVER -> false;
            case Transformation.ALWAYS -> true;
            case Transformation.WHEN_NEEDED -> whenNeeded.test(configuration);
            default -> throw new IllegalStateException("Transformation configuration not supported: " + String.valueOf((Object)transformation));
        }) && configuration.requireCommercial(() -> "SQL transformation " + label + " required. SQL transformations are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition or jOOQ Enterprise Edition.");
    }
}

