/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.util.postgres;

import com.oheers.fish.libs.jooq.EnumType;
import com.oheers.fish.libs.jooq.JSONB;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.exception.DataTypeException;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.tools.StringUtils;
import com.oheers.fish.libs.jooq.types.DayToSecond;
import com.oheers.fish.libs.jooq.types.YearToMonth;
import com.oheers.fish.libs.jooq.types.YearToSecond;
import com.oheers.fish.libs.jooq.util.postgres.PGInterval;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PostgresUtils {
    private static final String POSTGRESQL_HEX_STRING_PREFIX = "\\x";

    public static byte[] toBytes(String string) {
        if (string.startsWith(POSTGRESQL_HEX_STRING_PREFIX)) {
            return PostgresUtils.toBytesFromHexEncoding(string);
        }
        return PostgresUtils.toBytesFromOctalEncoding(string);
    }

    private static byte[] toBytesFromOctalEncoding(String string) {
        StringReader reader = new StringReader(string);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            PostgresUtils.convertOctalToBytes(reader, bytes);
            return bytes.toByteArray();
        }
        catch (IOException x) {
            throw new DataTypeException("failed to parse octal hex string: " + x.getMessage(), x);
        }
    }

    private static void convertOctalToBytes(Reader reader, OutputStream bytes) throws IOException {
        int ch;
        while ((ch = reader.read()) != -1) {
            if (ch == 92) {
                ch = reader.read();
                if (ch == -1) {
                    throw new DataTypeException("unexpected end of stream after initial backslash");
                }
                if (ch == 92) {
                    bytes.write(92);
                    continue;
                }
                int val = PostgresUtils.octalValue(ch);
                ch = reader.read();
                if (ch == -1) {
                    throw new DataTypeException("unexpected end of octal value");
                }
                val <<= 3;
                val += PostgresUtils.octalValue(ch);
                ch = reader.read();
                if (ch == -1) {
                    throw new DataTypeException("unexpected end of octal value");
                }
                val <<= 3;
                bytes.write(val += PostgresUtils.octalValue(ch));
                continue;
            }
            bytes.write(ch);
        }
    }

    private static byte[] toBytesFromHexEncoding(String string) {
        String hex = string.substring(POSTGRESQL_HEX_STRING_PREFIX.length());
        StringReader input = new StringReader(hex);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(hex.length() / 2);
        try {
            int hexDigit;
            while ((hexDigit = input.read()) != -1) {
                int byteValue = PostgresUtils.hexValue(hexDigit) << 4;
                hexDigit = input.read();
                if (hexDigit != -1) {
                    bytes.write(byteValue += PostgresUtils.hexValue(hexDigit));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new DataTypeException("Error while decoding hex string", e);
        }
        input.close();
        return bytes.toByteArray();
    }

    private static int hexValue(int hexDigit) {
        if (hexDigit >= 48 && hexDigit <= 57) {
            return hexDigit - 48;
        }
        if (hexDigit >= 97 && hexDigit <= 102) {
            return hexDigit - 97 + 10;
        }
        if (hexDigit >= 65 && hexDigit <= 70) {
            return hexDigit - 65 + 10;
        }
        throw new DataTypeException("unknown postgresql character format for hexValue: " + hexDigit);
    }

    private static int octalValue(int octalDigit) {
        if (octalDigit < 48 || octalDigit > 55) {
            throw new DataTypeException("unknown postgresql character format for octalValue: " + octalDigit);
        }
        return octalDigit - 48;
    }

    public static PGInterval toPGInterval(DayToSecond interval) {
        return new PGInterval(0, 0, interval.getSign() * interval.getDays(), interval.getSign() * interval.getHours(), interval.getSign() * interval.getMinutes(), (double)(interval.getSign() * interval.getSeconds()) + (double)(interval.getSign() * interval.getNano()) / 1.0E9);
    }

    public static PGInterval toPGInterval(YearToSecond interval) {
        return new PGInterval(interval.getSign() * interval.getYears(), interval.getSign() * interval.getMonths(), interval.getSign() * interval.getDays(), interval.getSign() * interval.getHours(), interval.getSign() * interval.getMinutes(), (double)(interval.getSign() * interval.getSeconds()) + (double)(interval.getSign() * interval.getNano()) / 1.0E9);
    }

    public static PGInterval toPGInterval(YearToMonth interval) {
        return new PGInterval(interval.getSign() * interval.getYears(), interval.getSign() * interval.getMonths(), 0, 0, 0, 0.0);
    }

    public static DayToSecond toDayToSecond(Object pgInterval) {
        if (pgInterval == null) {
            return null;
        }
        if (pgInterval instanceof PGInterval) {
            PGInterval i = (PGInterval)pgInterval;
            return PostgresUtils.toDayToSecond(i);
        }
        return PostgresUtils.toDayToSecond(new PGInterval(pgInterval.toString()));
    }

    public static DayToSecond toDayToSecond(PGInterval pgInterval) {
        boolean negative = pgInterval.toString().contains("-");
        if (negative) {
            pgInterval.scale(-1);
        }
        Double seconds = pgInterval.getSeconds();
        DayToSecond result = new DayToSecond(pgInterval.getDays(), pgInterval.getHours(), pgInterval.getMinutes(), seconds.intValue(), (int)(1.0E9 * (seconds - (double)seconds.intValue())));
        if (negative) {
            result = result.neg();
        }
        return result;
    }

    public static YearToMonth toYearToMonth(Object pgInterval) {
        if (pgInterval == null) {
            return null;
        }
        if (pgInterval instanceof PGInterval) {
            PGInterval i = (PGInterval)pgInterval;
            return PostgresUtils.toYearToMonth(i);
        }
        return PostgresUtils.toYearToMonth(new PGInterval(pgInterval.toString()));
    }

    public static YearToMonth toYearToMonth(PGInterval pgInterval) {
        boolean negative = pgInterval.toString().contains("-");
        if (negative) {
            pgInterval.scale(-1);
        }
        YearToMonth result = new YearToMonth(pgInterval.getYears(), pgInterval.getMonths());
        if (negative) {
            result = result.neg();
        }
        return result;
    }

    public static YearToSecond toYearToSecond(Object pgInterval) {
        return new YearToSecond(PostgresUtils.toYearToMonth(pgInterval), PostgresUtils.toDayToSecond(pgInterval));
    }

    public static List<String> toPGArray(String input) {
        if ("{}".equals(input)) {
            return Collections.emptyList();
        }
        return PostgresUtils.toPGObjectOrArray(input, '{', '}');
    }

    public static List<String> toPGObject(String input) {
        return PostgresUtils.toPGObjectOrArray(input, '(', ')');
    }

    private static List<String> toPGObjectOrArray(String input, char open, char close) {
        ArrayList<String> values = new ArrayList<String>();
        int i0 = 0;
        PGState state = PGState.PG_OBJECT_INIT;
        int nestLevel = 0;
        StringBuilder sb = null;
        block9: for (int i = 0; i < input.length(); ++i) {
            char c2 = input.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (c2 != open) continue block9;
                    state = PGState.PG_OBJECT_BEFORE_VALUE;
                    continue block9;
                }
                case 1: {
                    sb = null;
                    i0 = i;
                    if (c2 == ',') {
                        values.add(null);
                        state = PGState.PG_OBJECT_BEFORE_VALUE;
                        continue block9;
                    }
                    if (c2 == close) {
                        values.add(null);
                        state = PGState.PG_OBJECT_END;
                        continue block9;
                    }
                    if (c2 == '\"') {
                        state = PGState.PG_OBJECT_QUOTED_VALUE;
                        i0 = i + 1;
                        continue block9;
                    }
                    if ((c2 == 'n' || c2 == 'N') && i + 4 < input.length() && open == '{' && input.substring(i, i + 4).equalsIgnoreCase("null")) {
                        values.add(null);
                        i += 3;
                        state = PGState.PG_OBJECT_AFTER_VALUE;
                        continue block9;
                    }
                    if (c2 == open) {
                        sb = new StringBuilder();
                        sb.append(c2);
                        state = PGState.PG_OBJECT_NESTED_VALUE;
                        ++nestLevel;
                        continue block9;
                    }
                    state = PGState.PG_OBJECT_UNQUOTED_VALUE;
                    continue block9;
                }
                case 2: {
                    char n;
                    if (c2 == '\"') {
                        if (input.charAt(i + 1) == '\"') {
                            if (sb == null) {
                                sb = new StringBuilder().append(input.substring(i0, i));
                            }
                            sb.append(c2);
                            ++i;
                            continue block9;
                        }
                        if (sb == null) {
                            values.add(input.substring(i0, i));
                        } else {
                            values.add(sb.toString());
                        }
                        state = PGState.PG_OBJECT_AFTER_VALUE;
                        continue block9;
                    }
                    if (c2 == '\\') {
                        n = input.charAt(i + 1);
                        if (n == '\\' || n == '\"') {
                            if (sb == null) {
                                sb = new StringBuilder().append(input.substring(i0, i));
                            }
                            sb.append(n);
                            ++i;
                            continue block9;
                        }
                        if (sb == null) continue block9;
                        sb.append(c2);
                        continue block9;
                    }
                    if (sb == null) continue block9;
                    sb.append(c2);
                    continue block9;
                }
                case 3: {
                    if (c2 == close) {
                        values.add(input.substring(i0, i));
                        state = PGState.PG_OBJECT_END;
                        continue block9;
                    }
                    if (c2 != ',') continue block9;
                    values.add(input.substring(i0, i));
                    state = PGState.PG_OBJECT_BEFORE_VALUE;
                    continue block9;
                }
                case 4: {
                    if (c2 == close) {
                        sb.append(c2);
                        if (--nestLevel != 0) continue block9;
                        values.add(sb.toString());
                        state = PGState.PG_OBJECT_AFTER_VALUE;
                        continue block9;
                    }
                    if (c2 == open) {
                        ++nestLevel;
                        sb.append(c2);
                        continue block9;
                    }
                    if (c2 == '\"') {
                        state = PGState.PG_OBJECT_NESTED_QUOTED_VALUE;
                        sb.append(c2);
                        continue block9;
                    }
                    sb.append(c2);
                    continue block9;
                }
                case 5: {
                    char n;
                    if (c2 == '\"') {
                        if (input.charAt(i + 1) == '\"') {
                            sb.append(c2);
                            sb.append(c2);
                            ++i;
                            continue block9;
                        }
                        sb.append(c2);
                        state = PGState.PG_OBJECT_NESTED_VALUE;
                        continue block9;
                    }
                    if (c2 == '\\') {
                        n = input.charAt(i + 1);
                        if (n == '\\' || n == '\"') {
                            sb.append(c2);
                            sb.append(n);
                            ++i;
                            continue block9;
                        }
                        sb.append(c2);
                        continue block9;
                    }
                    sb.append(c2);
                    continue block9;
                }
                case 6: {
                    if (c2 == close) {
                        state = PGState.PG_OBJECT_END;
                        continue block9;
                    }
                    if (c2 != ',') continue block9;
                    state = PGState.PG_OBJECT_BEFORE_VALUE;
                }
            }
        }
        return values;
    }

    public static String toPGArrayString(Object[] value) {
        return PostgresUtils.toPGArrayString0(value, new StringBuilder()).toString();
    }

    private static StringBuilder toPGArrayString0(Object[] value, StringBuilder sb) {
        sb.append("{");
        String separator = "";
        for (Object o : value) {
            sb.append(separator);
            if (o == null) {
                sb.append(o);
            } else if (o instanceof Number) {
                sb.append(PostgresUtils.toPGString(o));
            } else if (o instanceof byte[]) {
                PostgresUtils.toPGString0((byte[])o, sb);
            } else if (o instanceof Object[]) {
                Object[] a2 = (Object[])o;
                if (!PostgresUtils.isDeepEmpty(a2)) {
                    PostgresUtils.toPGArrayString0(a2, sb);
                }
            } else {
                sb.append("\"").append(StringUtils.replace(StringUtils.replace(PostgresUtils.toPGString(o), "\\", "\\\\"), "\"", "\\\"")).append("\"");
            }
            separator = ",";
        }
        sb.append("}");
        return sb;
    }

    private static boolean isDeepEmpty(Object[] a2) {
        Object object;
        if (a2.length == 0) {
            return true;
        }
        if (a2.length == 1 && (object = a2[0]) instanceof Object[]) {
            Object[] b2 = (Object[])object;
            return PostgresUtils.isDeepEmpty(b2);
        }
        return false;
    }

    public static String toPGString(Object o) {
        if (o instanceof byte[]) {
            byte[] a2 = (byte[])o;
            return PostgresUtils.toPGString(a2);
        }
        if (o instanceof Object[]) {
            Object[] a3 = (Object[])o;
            return PostgresUtils.toPGArrayString(a3);
        }
        if (o instanceof Record) {
            Record r = (Record)o;
            return PostgresUtils.toPGString(r);
        }
        if (o instanceof EnumType) {
            EnumType e = (EnumType)o;
            return e.getLiteral();
        }
        if (o instanceof JSONB) {
            JSONB d2 = (JSONB)o;
            return d2.data();
        }
        return String.valueOf(o);
    }

    public static String toPGString(Record r) {
        return PostgresUtils.toPGString0(r, new StringBuilder()).toString();
    }

    private static StringBuilder toPGString0(Record r, StringBuilder sb) {
        sb.append("(");
        String separator = "";
        for (int i = 0; i < r.size(); ++i) {
            Object a2 = r.field(i).getConverter().to(r.get(i), Internal.converterContext());
            sb.append(separator);
            if (a2 != null) {
                if (a2 instanceof byte[]) {
                    PostgresUtils.toPGString0((byte[])a2, sb);
                } else {
                    sb.append("\"").append(StringUtils.replace(StringUtils.replace(PostgresUtils.toPGString(a2), "\\", "\\\\"), "\"", "\\\"")).append("\"");
                }
            }
            separator = ",";
        }
        sb.append(")");
        return sb;
    }

    public static String toPGString(byte[] binary) {
        return PostgresUtils.toPGString0(binary, new StringBuilder()).toString();
    }

    private static StringBuilder toPGString0(byte[] binary, StringBuilder sb) {
        for (byte b2 : binary) {
            sb.append("\\\\");
            sb.append(StringUtils.leftPad(Integer.toOctalString(b2 & 0xFF), 3, '0'));
        }
        return sb;
    }

    static enum PGState {
        PG_OBJECT_INIT,
        PG_OBJECT_BEFORE_VALUE,
        PG_OBJECT_QUOTED_VALUE,
        PG_OBJECT_UNQUOTED_VALUE,
        PG_OBJECT_NESTED_VALUE,
        PG_OBJECT_NESTED_QUOTED_VALUE,
        PG_OBJECT_AFTER_VALUE,
        PG_OBJECT_END;

    }
}

