/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.messagelib.message;

import com.oheers.fish.libs.messagelib.ObjectProcessor;
import com.oheers.fish.libs.messagelib.Utils;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import com.oheers.fish.libs.messagelib.message.MessageType;
import com.oheers.fish.libs.messagelib.replacer.Replacer;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentSingleMessage
extends ComponentMessage {
    private final Component message;
    private final MessageType messageType;

    protected ComponentSingleMessage(@NotNull Component message, @NotNull MessageType messageType) {
        this.message = ComponentMessage.ROOT.append(message);
        this.messageType = messageType;
    }

    @NotNull
    public Component get() {
        return this.message;
    }

    @NotNull
    public String getAsPlainText() {
        return PlainTextComponentSerializer.plainText().serialize(this.message);
    }

    @NotNull
    public String getAsJson() {
        return (String)GsonComponentSerializer.gson().serialize(this.message);
    }

    @NotNull
    public String getAsLegacy() {
        return LegacyComponentSerializer.legacySection().serialize(this.message);
    }

    @NotNull
    public String getAsMiniMessage() {
        return (String)MiniMessage.miniMessage().serialize(this.message);
    }

    @Override
    public ComponentSingleMessage createCopy() {
        return new ComponentSingleMessage(this.message, this.messageType);
    }

    @Override
    @NotNull
    public MessageType messageType() {
        return this.messageType;
    }

    @Override
    public ComponentSingleMessage messageType(@NotNull MessageType messageType) {
        return new ComponentSingleMessage(this.message, messageType);
    }

    @Override
    public ComponentSingleMessage append(@NotNull Object append) {
        return new ComponentSingleMessage(this.message.append(Component.join((JoinConfiguration)JoinConfiguration.newlines(), ObjectProcessor.process(append))), this.messageType);
    }

    @Override
    public ComponentSingleMessage prepend(@NotNull Object prepend) {
        return new ComponentSingleMessage(Component.join((JoinConfiguration)JoinConfiguration.newlines(), ObjectProcessor.process(prepend)), this.messageType).append(this.message);
    }

    @Override
    public ComponentSingleMessage replace(@NotNull String placeholder, @Nullable Object replacement) {
        Replacer replacer = Replacer.replacer().addReplacement(placeholder, replacement);
        return new ComponentSingleMessage(replacer.apply(this.message), this.messageType);
    }

    @Override
    public ComponentSingleMessage replace(@NotNull Map<String, ?> replacements) {
        Replacer replacer = Replacer.replacer().addReplacements(replacements);
        return new ComponentSingleMessage(replacer.apply(this.message), this.messageType);
    }

    @Override
    public ComponentSingleMessage replace(@Nullable Replacer replacer) {
        if (replacer == null) {
            return this;
        }
        return new ComponentSingleMessage(replacer.apply(this.message), this.messageType);
    }

    @Override
    public ComponentSingleMessage parsePlaceholderAPI(@Nullable OfflinePlayer player) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return this;
        }
        return new ComponentSingleMessage(Utils.parsePlaceholderAPI(this.message, player), this.messageType);
    }

    public boolean matchesString(@NotNull String string) {
        return this.getAsPlainText().equals(string);
    }

    public boolean containsString(@NotNull String string) {
        return this.getAsPlainText().contains(string);
    }

    @Override
    public boolean isEmpty() {
        return this.getAsPlainText().isEmpty();
    }

    @Override
    public int getLength() {
        return this.getAsPlainText().length();
    }

    public ComponentSingleMessage edit(@NotNull Function<Component, Component> editor) {
        return new ComponentSingleMessage(editor.apply(this.message), this.messageType);
    }

    @Override
    public void send(@Nullable Audience audience) {
        this.messageType.send(audience, this.message);
    }

    @Override
    public void send(@NotNull List<? extends Audience> audienceList) {
        audienceList.forEach(this::send);
    }

    @Override
    public void send(Audience ... audiences) {
        for (Audience audience : audiences) {
            this.send(audience);
        }
    }

    @Override
    public void broadcast() {
        Bukkit.broadcast((Component)this.message);
    }
}

