/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.messages;

import com.oheers.fish.libs.messagelib.message.ComponentListMessage;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import com.oheers.fish.libs.messagelib.message.ComponentSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMFListMessage
extends EMFMessage {
    private ComponentListMessage underlying;

    private EMFListMessage(@NotNull ComponentListMessage message) {
        this.underlying = message;
    }

    @Override
    public EMFListMessage createCopy() {
        EMFListMessage newMessage = new EMFListMessage(this.underlying.createCopy());
        newMessage.perPlayer = this.perPlayer;
        return newMessage;
    }

    @Override
    @NotNull
    public ComponentListMessage getUnderlying() {
        return this.underlying;
    }

    @Override
    public void setUnderlying(@NotNull ComponentMessage message) {
        if (message instanceof ComponentSingleMessage) {
            ComponentSingleMessage singleMessage = (ComponentSingleMessage)message;
            this.underlying = singleMessage.toListMessage();
        } else if (message instanceof ComponentListMessage) {
            ComponentListMessage listMessage;
            this.underlying = listMessage = (ComponentListMessage)message;
        } else {
            return;
        }
    }

    public static EMFListMessage empty() {
        return new EMFListMessage(ComponentMessage.componentMessage(List.of()));
    }

    public static EMFListMessage ofUnderlying(@NotNull ComponentListMessage underlying) {
        return new EMFListMessage(underlying);
    }

    public static EMFListMessage of(@NotNull Component component) {
        return new EMFListMessage(ComponentMessage.componentMessage(List.of(component)));
    }

    public static EMFListMessage ofList(@NotNull List<Component> components) {
        return new EMFListMessage(ComponentMessage.componentMessage(components));
    }

    public static EMFListMessage fromString(@NotNull String string) {
        return new EMFListMessage(ComponentMessage.componentMessage(List.of(string)));
    }

    public static EMFListMessage fromStringList(@NotNull List<String> strings) {
        return new EMFListMessage(ComponentMessage.componentMessage(strings));
    }

    @NotNull
    public List<Component> getRawMessage() {
        return this.underlying.get();
    }

    @Override
    @NotNull
    public Component getComponentMessage(@Nullable OfflinePlayer player) {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), this.getComponentListMessage(player));
    }

    @Override
    @NotNull
    public List<Component> getComponentListMessage(@Nullable OfflinePlayer player) {
        OfflinePlayer relevant = this.relevantPlayer == null ? player : this.relevantPlayer;
        return this.underlying.parsePlaceholderAPI(relevant).replace("{player}", Optional.ofNullable(relevant).map(OfflinePlayer::getName).orElse("null")).get();
    }

    @Override
    @NotNull
    public String getLegacyMessage() {
        return String.join((CharSequence)"\n", this.underlying.getAsLegacy());
    }

    @Override
    @NotNull
    public List<String> getLegacyListMessage() {
        return this.underlying.getAsLegacy();
    }

    @Override
    @NotNull
    public String getPlainTextMessage() {
        return String.join((CharSequence)"\n", this.underlying.getAsPlainText());
    }

    @Override
    @NotNull
    public List<String> getPlainTextListMessage() {
        return this.underlying.getAsPlainText();
    }

    @Override
    public void formatPlaceholderAPI() {
        this.underlying = this.underlying.parsePlaceholderAPI(this.relevantPlayer);
    }

    @Override
    public boolean containsString(@NotNull String string) {
        return this.underlying.toSingleMessages().stream().anyMatch(singleMessage -> singleMessage.containsString(string));
    }

    public void setVariableWithListInsertion(@NotNull String variable, @NotNull Object replacement) {
        this.underlying = this.underlying.replaceWithListInsertion(variable, replacement);
    }

    public void setVariablesWithListInsertion(@Nullable Map<String, ?> variableMap) {
        if (variableMap == null || variableMap.isEmpty()) {
            return;
        }
        this.underlying = this.underlying.replaceWithListInsertion(variableMap);
    }
}

